/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hash.GeodeRedisHashSynchronized;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HGetAllExecutor
extends HashExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HGETALL command is \"HGETALL key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        GeodeRedisHashSynchronized hash = new GeodeRedisHashSynchronized(key, context);
        Collection<Map.Entry<ByteArrayWrapper, ByteArrayWrapper>> entries = hash.hgetall();
        command.setResponse(Coder.getKeyValArrayResponse(context.getByteBufAllocator(), entries));
    }
}

