/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.redis.internal.ChannelSubscription;
import org.apache.geode.redis.internal.Client;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.PatternSubscription;
import org.apache.geode.redis.internal.PubSub;
import org.apache.geode.redis.internal.PublishResult;
import org.apache.geode.redis.internal.Subscriptions;
import org.apache.geode.redis.internal.org.apache.hadoop.fs.GlobPattern;

public class PubSubImpl
implements PubSub {
    public static final String REDIS_PUB_SUB_FUNCTION_ID = "redisPubSubFunctionID";
    private final Subscriptions subscriptions;

    public PubSubImpl(Subscriptions subscriptions) {
        this.subscriptions = subscriptions;
        this.registerPublishFunction();
    }

    @Override
    public long publish(String channel, byte[] message) {
        ResultCollector subscriberCountCollector = FunctionService.onMembers((String[])new String[0]).setArguments((Object)new Object[]{channel, message}).execute(REDIS_PUB_SUB_FUNCTION_ID);
        List subscriberCounts = (List)subscriberCountCollector.getResult();
        return subscriberCounts.stream().mapToLong(x -> x).sum();
    }

    @Override
    public long subscribe(String channel, ExecutionHandlerContext context, Client client) {
        if (this.subscriptions.exists(channel, client)) {
            return this.subscriptions.findSubscriptions(client).size();
        }
        ChannelSubscription subscription = new ChannelSubscription(client, channel, context);
        this.subscriptions.add(subscription);
        return this.subscriptions.findSubscriptions(client).size();
    }

    @Override
    public long psubscribe(GlobPattern pattern, ExecutionHandlerContext context, Client client) {
        if (this.subscriptions.exists(pattern, client)) {
            return this.subscriptions.findSubscriptions(client).size();
        }
        PatternSubscription subscription = new PatternSubscription(client, pattern, context);
        this.subscriptions.add(subscription);
        return this.subscriptions.findSubscriptions(client).size();
    }

    private void registerPublishFunction() {
        FunctionService.registerFunction((Function)new Function<Object[]>(){

            public String getId() {
                return PubSubImpl.REDIS_PUB_SUB_FUNCTION_ID;
            }

            public void execute(FunctionContext<Object[]> context) {
                Object[] publishMessage = (Object[])context.getArguments();
                long subscriberCount = PubSubImpl.this.publishMessageToSubscribers((String)publishMessage[0], (byte[])publishMessage[1]);
                context.getResultSender().lastResult((Object)subscriberCount);
            }
        });
    }

    @Override
    public long unsubscribe(String channel, Client client) {
        this.subscriptions.remove(channel, client);
        return this.subscriptions.findSubscriptions(client).size();
    }

    @Override
    public long punsubscribe(GlobPattern pattern, Client client) {
        this.subscriptions.remove(pattern, client);
        return this.subscriptions.findSubscriptions(client).size();
    }

    @VisibleForTesting
    long publishMessageToSubscribers(String channel, byte[] message) {
        Map<Boolean, List<PublishResult>> results = this.subscriptions.findSubscriptions(channel).stream().map(subscription -> subscription.publishMessage(channel, message)).collect(Collectors.partitioningBy(PublishResult::isSuccessful));
        this.prune(results.get(false));
        return results.get(true).size();
    }

    private void prune(List<PublishResult> failedSubscriptions) {
        failedSubscriptions.forEach(publishResult -> {
            Client client = publishResult.getClient();
            if (client.isDead()) {
                this.subscriptions.remove(client);
            }
        });
    }
}

