/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.redis.internal.AbstractSubscription;
import org.apache.geode.redis.internal.Client;
import org.apache.geode.redis.internal.ExecutionHandlerContext;

class ChannelSubscription
extends AbstractSubscription {
    private String channel;

    public ChannelSubscription(Client client, String channel, ExecutionHandlerContext context) {
        super(client, context);
        if (channel == null) {
            throw new IllegalArgumentException("channel cannot be null");
        }
        this.channel = channel;
    }

    @Override
    public List<Object> createResponse(String channel, byte[] message) {
        return Arrays.asList("message", channel, message);
    }

    @Override
    public boolean isEqualTo(Object channelOrPattern, Client client) {
        return this.channel != null && this.channel.equals(channelOrPattern) && this.getClient().equals(client);
    }

    @Override
    public boolean matches(String channel) {
        return this.channel.equals(channel);
    }
}

