/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.SingleHopClientExecutor;
import org.apache.geode.cache.client.internal.SingleHopOperationCallable;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RemoveAllOp {
    public static final Logger logger = LogService.getLogger();
    public static final int FLAG_EMPTY = 1;
    public static final int FLAG_CONCURRENCY_CHECKS = 2;

    public static VersionedObjectList execute(ExecutablePool pool, Region region, Collection<Object> keys, EventID eventId, boolean isRetry, Object callbackArg) {
        RemoveAllOpImpl op = new RemoveAllOpImpl(region, keys, eventId, ((PoolImpl)pool).getPRSingleHopEnabled(), callbackArg);
        op.initMessagePart();
        if (isRetry) {
            op.getMessage().setIsRetry();
        }
        return (VersionedObjectList)pool.execute(op);
    }

    public static VersionedObjectList execute(ExecutablePool pool, Region region, Collection<Object> keys, EventID eventId, int retryAttempts, Object callbackArg) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        ClientMetadataService cms = ((InternalRegion)region).getCache().getClientMetadataService();
        Map<ServerLocation, Set> serverToFilterMap = cms.getServerToFilterMap(keys, region, true);
        if (serverToFilterMap == null || serverToFilterMap.isEmpty()) {
            RemoveAllOpImpl op = new RemoveAllOpImpl(region, keys, eventId, ((PoolImpl)pool).getPRSingleHopEnabled(), callbackArg);
            ((AbstractOp)op).initMessagePart();
            return (VersionedObjectList)pool.execute(op);
        }
        List callableTasks = RemoveAllOp.constructAndGetRemoveAllTasks(region, eventId, serverToFilterMap, (PoolImpl)pool, callbackArg);
        if (isDebugEnabled) {
            logger.debug("RemoveAllOp#execute : Number of removeAll tasks is :{}", (Object)callableTasks.size());
        }
        HashMap<ServerLocation, RuntimeException> failedServers = new HashMap<ServerLocation, RuntimeException>();
        PutAllPartialResultException.PutAllPartialResult result = new PutAllPartialResultException.PutAllPartialResult(keys.size());
        try {
            Map<ServerLocation, Object> results = SingleHopClientExecutor.submitBulkOp(callableTasks, cms, (LocalRegion)region, failedServers);
            for (Map.Entry<ServerLocation, Object> entry : results.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof PutAllPartialResultException) {
                    PutAllPartialResultException pap = (PutAllPartialResultException)value;
                    if (isDebugEnabled) {
                        logger.debug("RemoveAll SingleHop encountered BulkOpPartialResultException exception: {}, failedServers are {}", (Object)pap, failedServers.keySet());
                    }
                    result.consolidate(pap.getResult());
                    continue;
                }
                if (value == null) continue;
                VersionedObjectList list = (VersionedObjectList)value;
                result.addKeysAndVersions(list);
            }
        }
        catch (RuntimeException ex) {
            logger.debug("single-hop removeAll encountered unexpected exception: {}", (Throwable)ex);
            throw ex;
        }
        if (!failedServers.isEmpty()) {
            if (retryAttempts == 0) {
                throw failedServers.values().iterator().next();
            }
            if (result.getSucceededKeysAndVersions().size() == 0) {
                LinkedHashSet succeedKeySet = new LinkedHashSet();
                Set<ServerLocation> serverSet = serverToFilterMap.keySet();
                for (ServerLocation server : serverSet) {
                    if (failedServers.containsKey(server)) continue;
                    succeedKeySet.addAll(serverToFilterMap.get(server));
                }
                result.addKeys(succeedKeySet);
            }
            boolean oneSubMapRetryFailed = false;
            Set<ServerLocation> failedServerSet = failedServers.keySet();
            for (ServerLocation failedServer : failedServerSet) {
                RuntimeException savedRTE = failedServers.get(failedServer);
                if (savedRTE instanceof PutAllPartialResultException) {
                    oneSubMapRetryFailed = true;
                    continue;
                }
                Collection newKeys = serverToFilterMap.get(failedServer);
                try {
                    VersionedObjectList v = RemoveAllOp.execute(pool, region, (Collection<Object>)newKeys, eventId, true, callbackArg);
                    if (v == null) {
                        result.addKeys(newKeys);
                        continue;
                    }
                    result.addKeysAndVersions(v);
                }
                catch (PutAllPartialResultException pre) {
                    oneSubMapRetryFailed = true;
                    logger.debug("Retry failed with BulkOpPartialResultException: {} Before retry: {}", (Object)pre, (Object)result.getKeyListString());
                    result.consolidate(pre.getResult());
                }
                catch (Exception rte) {
                    oneSubMapRetryFailed = true;
                    Object firstKey = newKeys.iterator().next();
                    result.saveFailedKey(firstKey, rte);
                }
            }
            if (oneSubMapRetryFailed && result.hasFailure()) {
                PutAllPartialResultException putAllPartialResultException = new PutAllPartialResultException(result);
                throw putAllPartialResultException;
            }
        }
        return result.getSucceededKeysAndVersions();
    }

    private RemoveAllOp() {
    }

    static List constructAndGetRemoveAllTasks(Region region, EventID eventId, Map<ServerLocation, Set> serverToFilterMap, PoolImpl pool, Object callbackArg) {
        ArrayList<SingleHopOperationCallable> tasks = new ArrayList<SingleHopOperationCallable>();
        ArrayList<ServerLocation> servers = new ArrayList<ServerLocation>(serverToFilterMap.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("Constructing tasks for the servers{}", servers);
        }
        for (ServerLocation server : servers) {
            RemoveAllOpImpl RemoveAllOp2 = new RemoveAllOpImpl(region, serverToFilterMap.get(server), eventId, true, callbackArg);
            SingleHopOperationCallable task = new SingleHopOperationCallable(new ServerLocation(server.getHostName(), server.getPort()), pool, RemoveAllOp2, UserAttributes.userAttributes.get());
            tasks.add(task);
        }
        return tasks;
    }

    private static class RemoveAllOpImpl
    extends AbstractOp {
        private boolean prSingleHopEnabled = false;
        private LocalRegion region = null;
        private Collection<Object> keys = null;
        private final Object callbackArg;

        public RemoveAllOpImpl(Region region, Collection<Object> keys, EventID eventId, boolean prSingleHopEnabled, Object callbackArg) {
            super(109, 5 + keys.size());
            this.prSingleHopEnabled = prSingleHopEnabled;
            this.region = (LocalRegion)region;
            this.getMessage().addStringPart(region.getFullPath(), true);
            this.getMessage().addBytesPart(eventId.calcBytes());
            this.keys = keys;
            this.callbackArg = callbackArg;
        }

        @Override
        protected void initMessagePart() {
            int size = this.keys.size();
            int flags = 0;
            if (this.region.getDataPolicy() == DataPolicy.EMPTY) {
                flags |= 1;
            }
            if (this.region.getConcurrencyChecksEnabled()) {
                flags |= 2;
            }
            this.getMessage().addIntPart(flags);
            this.getMessage().addObjPart(this.callbackArg);
            this.getMessage().addIntPart(size);
            for (Object key : this.keys) {
                this.getMessage().addStringOrObjPart(key);
            }
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(2, Version.CURRENT);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object processResponse(final Message msg, final Connection con) throws Exception {
            final VersionedObjectList result = new VersionedObjectList();
            final Exception[] exceptionRef = new Exception[1];
            final boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                this.processChunkedResponse((ChunkedMessage)msg, "removeAll", new AbstractOp.ChunkHandler(){

                    @Override
                    public void handle(ChunkedMessage cm) throws Exception {
                        int numParts = msg.getNumberOfParts();
                        if (isDebugEnabled) {
                            logger.debug("RemoveAllOp.processChunkedResponse processing message with {} parts", (Object)numParts);
                        }
                        for (int partNo = 0; partNo < numParts; ++partNo) {
                            Part part = cm.getPart(partNo);
                            try {
                                Object o = part.getObject();
                                if (isDebugEnabled) {
                                    logger.debug("part({}) contained {}", (Object)partNo, o);
                                }
                                if (o == null) continue;
                                if (o instanceof byte[]) {
                                    byte[] bytesReceived;
                                    if (!prSingleHopEnabled || (bytesReceived = part.getSerializedForm())[0] == 0 || region == null) continue;
                                    try {
                                        ClientMetadataService cms = region.getCache().getClientMetadataService();
                                        cms.scheduleGetPRMetaData(region, false, bytesReceived[1]);
                                    }
                                    catch (CacheClosedException cacheClosedException) {}
                                    continue;
                                }
                                if (o instanceof Throwable) {
                                    String s = "While performing a remote removeAll";
                                    exceptionRef[0] = new ServerOperationException(s, (Throwable)o);
                                    continue;
                                }
                                VersionedObjectList chunk = (VersionedObjectList)o;
                                chunk.replaceNullIDs(con.getEndpoint().getMemberId());
                                result.addAll(chunk);
                                continue;
                            }
                            catch (Exception e) {
                                exceptionRef[0] = new ServerOperationException("Unable to deserialize value", e);
                            }
                        }
                    }
                });
            }
            catch (ServerOperationException e) {
                if (e.getCause() instanceof PutAllPartialResultException) {
                    PutAllPartialResultException cause = (PutAllPartialResultException)e.getCause();
                    cause.getSucceededKeysAndVersions().replaceNullIDs(con.getEndpoint().getMemberId());
                    throw cause;
                }
                throw e;
            }
            if (exceptionRef[0] != null) {
                throw exceptionRef[0];
            }
            if (result.hasVersions() && result.getKeys().isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("setting keys of response to {}", this.keys);
                }
                ArrayList<Object> tmpKeys = this.keys instanceof ArrayList ? (ArrayList<Object>)this.keys : new ArrayList<Object>(this.keys);
                result.setKeys(tmpKeys);
            }
            return result;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 8;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startRemoveAll();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endRemoveAllSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endRemoveAll(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

