/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.membership.api.MemberData;
import org.apache.geode.distributed.internal.membership.api.MemberDataBuilder;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionOrdinal;
import org.apache.geode.internal.serialization.Versioning;
import org.jgroups.util.UUID;

public class MemberIdentifierImpl
implements MemberIdentifier,
DataSerializableFixedID {
    @Immutable
    private static final Version[] dsfidVersions = new Version[]{Version.GFE_71, Version.GFE_90};
    private MemberData memberData;
    private transient String cachedToString;

    public MemberIdentifierImpl() {
    }

    public MemberIdentifierImpl(MemberData memberData) {
        this.memberData = memberData;
    }

    public int getVmPid() {
        return this.memberData.getProcessId();
    }

    @Override
    public void setDurableTimeout(int newValue) {
        this.memberData.setDurableTimeout(newValue);
    }

    @Override
    public void setDurableId(String id) {
        this.memberData.setDurableId(id);
    }

    @Override
    public void setMemberData(MemberData m) {
        this.memberData = m;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.memberData.getInetAddress();
    }

    @Override
    public int getMembershipPort() {
        return this.memberData.getMembershipPort();
    }

    @Override
    public short getVersionOrdinal() {
        return this.memberData.getVersionOrdinal();
    }

    @Override
    public int getDirectChannelPort() {
        assert (!this.isPartial());
        return this.memberData.getDirectChannelPort();
    }

    @Override
    public int getVmKind() {
        return this.memberData.getVmKind();
    }

    @Override
    public int getMemberWeight() {
        return this.memberData.getMemberWeight();
    }

    @Override
    public int getVmViewId() {
        return this.memberData.getVmViewId();
    }

    @Override
    public boolean preferredForCoordinator() {
        return this.memberData.isPreferredForCoordinator();
    }

    @Override
    public List<String> getGroups() {
        String[] groups = this.memberData.getGroups();
        return groups == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(groups));
    }

    @Override
    public void setVmViewId(int p) {
        this.memberData.setVmViewId(p);
        this.cachedToString = null;
    }

    @Override
    public void setPreferredForCoordinator(boolean preferred) {
        this.memberData.setPreferredForCoordinator(preferred);
        this.cachedToString = null;
    }

    @Override
    public void setDirectChannelPort(int dcPort) {
        this.memberData.setDirectChannelPort(dcPort);
        this.cachedToString = null;
    }

    @Override
    public void setVmKind(int dmType) {
        this.memberData.setVmKind(dmType);
        this.cachedToString = null;
    }

    public void setGroups(String[] newGroups) {
        this.memberData.setGroups(newGroups);
        this.cachedToString = null;
    }

    @Override
    public String getName() {
        String result = this.memberData.getName();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public void setName(String name) {
        this.memberData.setName(name);
    }

    @Override
    public String getUniqueTag() {
        return this.memberData.getUniqueTag();
    }

    @Override
    public String getDurableId() {
        return this.memberData.getDurableId();
    }

    @Override
    public int getDurableTimeout() {
        return this.memberData.getDurableTimeout();
    }

    @Override
    public void setHostName(String hostName) {
        this.memberData.setHostName(hostName);
    }

    @Override
    public void setProcessId(int id) {
        this.memberData.setProcessId(id);
    }

    @Override
    public boolean hasUUID() {
        return this.memberData.hasUUID();
    }

    public int compare(MemberIdentifier other) {
        return this.compareTo(other, false, true);
    }

    @Override
    public int compareTo(MemberIdentifier other, boolean compareMemberData, boolean compareViewIds) {
        int i;
        byte[] otherBytes;
        int otherPort;
        int myPort = this.getMembershipPort();
        if (myPort < (otherPort = other.getMembershipPort())) {
            return -1;
        }
        if (myPort > otherPort) {
            return 1;
        }
        InetAddress myAddr = this.getInetAddress();
        InetAddress otherAddr = other.getInetAddress();
        if (myAddr == null && otherAddr == null) {
            return 0;
        }
        if (myAddr == null) {
            return -1;
        }
        if (otherAddr == null) {
            return 1;
        }
        byte[] myBytes = myAddr.getAddress();
        if (myBytes != (otherBytes = otherAddr.getAddress())) {
            for (int i2 = 0; i2 < myBytes.length; ++i2) {
                if (i2 >= otherBytes.length) {
                    return -1;
                }
                if (myBytes[i2] < otherBytes[i2]) {
                    return -1;
                }
                if (myBytes[i2] <= otherBytes[i2]) continue;
                return 1;
            }
            if (myBytes.length > otherBytes.length) {
                return 1;
            }
        }
        String myName = this.getName();
        String otherName = other.getName();
        if (!(other.isPartial() || this.isPartial() || myName == null && otherName == null)) {
            if (myName == null) {
                return -1;
            }
            if (otherName == null) {
                return 1;
            }
            i = myName.compareTo(otherName);
            if (i != 0) {
                return i;
            }
        }
        if (this.getUniqueTag() == null && other.getUniqueTag() == null) {
            if (compareViewIds) {
                int thisViewId = this.getVmViewId();
                int otherViewId = other.getVmViewId();
                if (thisViewId >= 0 && otherViewId >= 0) {
                    if (thisViewId < otherViewId) {
                        return -1;
                    }
                    if (thisViewId > otherViewId) {
                        return 1;
                    }
                }
            }
        } else {
            if (this.getUniqueTag() == null) {
                return -1;
            }
            if (other.getUniqueTag() == null) {
                return 1;
            }
            i = this.getUniqueTag().compareTo(other.getUniqueTag());
            if (i != 0) {
                return i;
            }
        }
        if (compareMemberData && this.memberData != null && other.getMemberData() != null) {
            return this.memberData.compareAdditionalData(other.getMemberData());
        }
        return 0;
    }

    @Override
    public boolean isPartial() {
        return this.memberData.isPartial();
    }

    public boolean equals(Object obj) {
        int otherPort;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MemberIdentifierImpl)) {
            return false;
        }
        MemberIdentifierImpl other = (MemberIdentifierImpl)obj;
        int myPort = this.getMembershipPort();
        if (myPort != (otherPort = other.getMembershipPort())) {
            return false;
        }
        InetAddress myAddr = this.getInetAddress();
        InetAddress otherAddr = other.getInetAddress();
        if (myAddr == null && otherAddr == null) {
            return true;
        }
        if (!Objects.equals(myAddr, otherAddr)) {
            return false;
        }
        if (!(this.isPartial() || other.isPartial() || Objects.equals(this.getName(), other.getName()))) {
            return false;
        }
        if (this.getUniqueTag() == null && other.getUniqueTag() == null) {
            int thisViewId = this.getVmViewId();
            int otherViewId = other.getVmViewId();
            if (thisViewId >= 0 && otherViewId >= 0 && thisViewId != otherViewId) {
                return false;
            }
        } else if (!Objects.equals(this.getUniqueTag(), other.getUniqueTag())) {
            return false;
        }
        return this.memberData == null || other.memberData == null || 0 == this.memberData.compareAdditionalData(other.memberData);
    }

    public int hashCode() {
        int result = 0;
        result += this.memberData.getInetAddress().hashCode();
        return result += this.getMembershipPort();
    }

    private String shortName(String hostname) {
        if (hostname == null) {
            return "<null inet_addr hostname>";
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index);
        }
        return hostname;
    }

    public String toString() {
        String result = this.cachedToString;
        if (result == null) {
            StringBuilder sb = new StringBuilder();
            this.addFixedToString(sb, false);
            short version = this.memberData.getVersionOrdinal();
            if (version != Version.CURRENT.ordinal()) {
                sb.append("(version:").append(Versioning.getVersionOrdinal((short)version)).append(')');
            }
            this.cachedToString = result = sb.toString();
        }
        return result;
    }

    @Override
    public void addFixedToString(StringBuilder sb, boolean useIpAddress) {
        int vmViewId;
        String host;
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress != null && (inetAddress.isMulticastAddress() || useIpAddress)) {
            host = inetAddress.getHostAddress();
        } else {
            String hostName = this.memberData.getHostName();
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            boolean isIpAddress = inetAddressValidator.isValid(hostName);
            host = isIpAddress ? hostName : this.shortName(hostName);
        }
        sb.append(host);
        String myName = this.getName();
        int vmPid = this.memberData.getProcessId();
        byte vmKind = this.memberData.getVmKind();
        if (vmPid > 0 || vmKind != 10 || !"".equals(myName)) {
            sb.append("(");
            if (!"".equals(myName)) {
                sb.append(myName);
                if (vmPid > 0) {
                    sb.append(':');
                }
            }
            if (vmPid > 0) {
                sb.append(vmPid);
            }
            String vmStr = "";
            switch (vmKind) {
                case 10: {
                    break;
                }
                case 11: {
                    vmStr = ":locator";
                    break;
                }
                case 12: {
                    vmStr = ":admin";
                    break;
                }
                case 13: {
                    vmStr = ":loner";
                    break;
                }
                default: {
                    vmStr = ":<unknown:" + vmKind + ">";
                }
            }
            sb.append(vmStr);
            sb.append(")");
        }
        if (vmKind != 13 && this.memberData.isPreferredForCoordinator()) {
            sb.append("<ec>");
        }
        if ((vmViewId = this.getVmViewId()) >= 0) {
            sb.append("<v" + vmViewId + ">");
        }
        sb.append(":");
        sb.append(this.getMembershipPort());
        if (vmKind == 13) {
            String name;
            if (this.getUniqueTag() != null && this.getUniqueTag().length() != 0) {
                sb.append(":").append(this.getUniqueTag());
            }
            if ((name = this.getName()).length() != 0) {
                sb.append(":").append(name);
            }
        }
    }

    private short readVersion(int flags, DataInput in) throws IOException {
        if ((flags & 8) != 0) {
            short version = Version.readOrdinal((DataInput)in);
            return version;
        }
        Version v = StaticSerialization.getVersionForDataStreamOrNull((DataInput)in);
        if (v != null) {
            return v.ordinal();
        }
        return Version.CURRENT_ORDINAL;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.memberData.getVmKind() > 0);
        byte[] address = this.getInetAddress().getAddress();
        out.writeInt(address.length);
        out.write(address);
        out.writeInt(this.getMembershipPort());
        StaticSerialization.writeString((String)this.memberData.getHostName(), (DataOutput)out);
        int flags = 0;
        if (this.memberData.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.memberData.isPreferredForCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial()) {
            flags |= 4;
        }
        out.writeByte((byte)((flags |= 8) & 0xFF));
        out.writeInt(this.memberData.getDirectChannelPort());
        out.writeInt(this.memberData.getProcessId());
        out.writeInt(this.memberData.getVmKind());
        out.writeInt(this.memberData.getVmViewId());
        StaticSerialization.writeStringArray((String[])this.memberData.getGroups(), (DataOutput)out);
        StaticSerialization.writeString((String)this.memberData.getName(), (DataOutput)out);
        StaticSerialization.writeString((String)this.memberData.getUniqueTag(), (DataOutput)out);
        String durableId = this.memberData.getDurableId();
        StaticSerialization.writeString((String)(durableId == null ? "" : durableId), (DataOutput)out);
        StaticSerialization.writeInteger((Integer)(durableId == null ? 300 : this.memberData.getDurableTimeout()), (DataOutput)out);
        Version.writeOrdinal((DataOutput)out, (short)this.memberData.getVersionOrdinal(), (boolean)true);
        this.memberData.writeAdditionalData(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] addr = new byte[len];
        in.readFully(addr);
        InetAddress inetAddr = InetAddress.getByAddress(addr);
        int port = in.readInt();
        String hostName = StaticSerialization.readString((DataInput)in);
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        boolean isPartial = (flags & 4) != 0;
        int dcPort = in.readInt();
        int vmPid = in.readInt();
        int vmKind = in.readInt();
        int vmViewId = in.readInt();
        String[] groups = StaticSerialization.readStringArray((DataInput)in);
        String name = StaticSerialization.readString((DataInput)in);
        String uniqueTag = StaticSerialization.readString((DataInput)in);
        String durableId = StaticSerialization.readString((DataInput)in);
        int durableTimeout = in.readInt();
        short version = this.readVersion(flags, in);
        this.memberData = MemberDataBuilder.newBuilder(inetAddr, hostName).setMembershipPort(port).setDirectChannelPort(dcPort).setName(name).setNetworkPartitionDetectionEnabled(sbEnabled).setPreferredForCoordinator(elCoord).setVersionOrdinal(version).setVmPid(vmPid).setVmKind(vmKind).setVmViewId(vmViewId).setGroups(groups).setDurableId(durableId).setDurableTimeout(durableTimeout).setIsPartial(isPartial).setUniqueTag(uniqueTag).build();
        if (version >= Version.GFE_90.ordinal()) {
            try {
                this.memberData.readAdditionalData(in);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        assert (this.memberData.getVmKind() > 0);
    }

    public int getDSFID() {
        return 2184;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        this.toDataPre_GFE_9_0_0_0(out, context);
        if (this.memberData.getVersionOrdinal() >= Version.GFE_90.ordinal()) {
            this.memberData.writeAdditionalData(out);
        }
    }

    @Override
    public void toDataPre_GFE_9_0_0_0(DataOutput out, SerializationContext context) throws IOException {
        StaticSerialization.writeInetAddress((InetAddress)this.getInetAddress(), (DataOutput)out);
        out.writeInt(this.getMembershipPort());
        StaticSerialization.writeString((String)this.memberData.getHostName(), (DataOutput)out);
        int flags = 0;
        if (this.memberData.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.memberData.isPreferredForCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial()) {
            flags |= 4;
        }
        out.writeByte((byte)((flags |= 8) & 0xFF));
        out.writeInt(this.memberData.getDirectChannelPort());
        out.writeInt(this.memberData.getProcessId());
        byte vmKind = this.memberData.getVmKind();
        out.writeByte(vmKind);
        StaticSerialization.writeStringArray((String[])this.memberData.getGroups(), (DataOutput)out);
        StaticSerialization.writeString((String)this.memberData.getName(), (DataOutput)out);
        if (vmKind == 13) {
            StaticSerialization.writeString((String)this.memberData.getUniqueTag(), (DataOutput)out);
        } else {
            StaticSerialization.writeString((String)String.valueOf(this.memberData.getVmViewId()), (DataOutput)out);
        }
        String durableId = this.memberData.getDurableId();
        StaticSerialization.writeString((String)(durableId == null ? "" : durableId), (DataOutput)out);
        StaticSerialization.writeInteger((Integer)(durableId == null ? 300 : this.memberData.getDurableTimeout()), (DataOutput)out);
        short version = this.memberData.getVersionOrdinal();
        Version.writeOrdinal((DataOutput)out, (short)version, (boolean)true);
    }

    @Override
    public void toDataPre_GFE_7_1_0_0(DataOutput out, SerializationContext context) throws IOException {
        assert (this.memberData.getVmKind() > 0);
        StaticSerialization.writeInetAddress((InetAddress)this.getInetAddress(), (DataOutput)out);
        out.writeInt(this.getMembershipPort());
        StaticSerialization.writeString((String)this.memberData.getHostName(), (DataOutput)out);
        int flags = 0;
        if (this.memberData.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.memberData.isPreferredForCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial()) {
            flags |= 4;
        }
        out.writeByte((byte)(flags & 0xFF));
        out.writeInt(this.memberData.getDirectChannelPort());
        out.writeInt(this.memberData.getProcessId());
        out.writeByte(this.memberData.getVmKind());
        StaticSerialization.writeStringArray((String[])this.memberData.getGroups(), (DataOutput)out);
        StaticSerialization.writeString((String)this.memberData.getName(), (DataOutput)out);
        byte vmKind = this.memberData.getVmKind();
        if (vmKind == 13) {
            StaticSerialization.writeString((String)this.memberData.getUniqueTag(), (DataOutput)out);
        } else {
            StaticSerialization.writeString((String)String.valueOf(this.memberData.getVmViewId()), (DataOutput)out);
        }
        String durableId = this.memberData.getDurableId();
        StaticSerialization.writeString((String)(durableId == null ? "" : durableId), (DataOutput)out);
        StaticSerialization.writeInteger((Integer)(durableId == null ? 300 : this.memberData.getDurableTimeout()), (DataOutput)out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.fromDataPre_GFE_9_0_0_0(in, context);
        if (this.memberData.getVersionOrdinal() >= Version.GFE_90.ordinal()) {
            try {
                this.memberData.readAdditionalData(in);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }

    @Override
    public void fromDataPre_GFE_9_0_0_0(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        InetAddress inetAddr = StaticSerialization.readInetAddress((DataInput)in);
        int port = in.readInt();
        String hostName = StaticSerialization.readString((DataInput)in);
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        boolean isPartial = (flags & 4) != 0;
        int dcPort = in.readInt();
        int vmPid = in.readInt();
        int vmKind = in.readUnsignedByte();
        String[] groups = StaticSerialization.readStringArray((DataInput)in);
        int vmViewId = -1;
        String name = StaticSerialization.readString((DataInput)in);
        String uniqueTag = null;
        if (vmKind == 13) {
            uniqueTag = StaticSerialization.readString((DataInput)in);
        } else {
            String str = StaticSerialization.readString((DataInput)in);
            if (str != null) {
                vmViewId = Integer.parseInt(str);
            }
        }
        String durableId = StaticSerialization.readString((DataInput)in);
        int durableTimeout = in.readInt();
        short version = this.readVersion(flags, in);
        this.memberData = MemberDataBuilder.newBuilder(inetAddr, hostName).setMembershipPort(port).setDirectChannelPort(dcPort).setName(name).setNetworkPartitionDetectionEnabled(sbEnabled).setPreferredForCoordinator(elCoord).setVersionOrdinal(version).setVmPid(vmPid).setVmKind(vmKind).setVmViewId(vmViewId).setGroups(groups).setDurableId(durableId).setDurableTimeout(durableTimeout).setIsPartial(isPartial).setUniqueTag(uniqueTag).build();
        assert (this.memberData.getVmKind() > 0);
    }

    @Override
    public void fromDataPre_GFE_7_1_0_0(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        InetAddress inetAddr = StaticSerialization.readInetAddress((DataInput)in);
        int port = in.readInt();
        String hostName = StaticSerialization.readString((DataInput)in);
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        boolean isPartial = (flags & 4) != 0;
        int dcPort = in.readInt();
        int vmPid = in.readInt();
        int vmKind = in.readUnsignedByte();
        String[] groups = StaticSerialization.readStringArray((DataInput)in);
        int vmViewId = -1;
        String name = StaticSerialization.readString((DataInput)in);
        String uniqueTag = null;
        if (vmKind == 13) {
            uniqueTag = StaticSerialization.readString((DataInput)in);
        } else {
            String str = StaticSerialization.readString((DataInput)in);
            if (str != null) {
                vmViewId = Integer.parseInt(str);
            }
        }
        String durableId = StaticSerialization.readString((DataInput)in);
        int durableTimeout = in.readInt();
        short version = this.readVersion(flags, in);
        this.memberData = MemberDataBuilder.newBuilder(inetAddr, hostName).setMembershipPort(port).setDirectChannelPort(dcPort).setName(name).setNetworkPartitionDetectionEnabled(sbEnabled).setPreferredForCoordinator(elCoord).setVersionOrdinal(version).setVmPid(vmPid).setVmKind(vmKind).setVmViewId(vmViewId).setGroups(groups).setDurableId(durableId).setDurableTimeout(durableTimeout).setIsPartial(isPartial).setUniqueTag(uniqueTag).build();
        assert (this.memberData.getVmKind() > 0);
    }

    @Override
    public void _readEssentialData(DataInput in, Function<InetAddress, String> hostnameResolver) throws IOException, ClassNotFoundException {
        InetAddress inetAddr = StaticSerialization.readInetAddress((DataInput)in);
        int port = in.readInt();
        String hostName = hostnameResolver.apply(inetAddr);
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        int vmKind = in.readUnsignedByte();
        int vmViewId = -1;
        String uniqueTag = null;
        if (vmKind == 13) {
            uniqueTag = StaticSerialization.readString((DataInput)in);
        } else {
            String str = StaticSerialization.readString((DataInput)in);
            if (str != null) {
                vmViewId = Integer.parseInt(str);
            }
        }
        String name = StaticSerialization.readString((DataInput)in);
        this.memberData = MemberDataBuilder.newBuilder(inetAddr, hostName).setMembershipPort(port).setName(name).setNetworkPartitionDetectionEnabled(sbEnabled).setPreferredForCoordinator(elCoord).setVersionOrdinal(StaticSerialization.getVersionForDataStream((DataInput)in).ordinal()).setVmKind(vmKind).setVmViewId(vmViewId).setIsPartial(true).setUniqueTag(uniqueTag).build();
        if (StaticSerialization.getVersionForDataStream((DataInput)in).compareTo((VersionOrdinal)Version.GFE_90) == 0) {
            this.memberData.readAdditionalData(in);
        }
    }

    @Override
    public void writeEssentialData(DataOutput out) throws IOException {
        assert (this.memberData.getVmKind() > 0);
        StaticSerialization.writeInetAddress((InetAddress)this.getInetAddress(), (DataOutput)out);
        out.writeInt(this.getMembershipPort());
        int flags = 0;
        if (this.memberData.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.memberData.isPreferredForCoordinator()) {
            flags |= 2;
        }
        out.writeByte((byte)((flags |= 4) & 0xFF));
        byte vmKind = this.memberData.getVmKind();
        out.writeByte(vmKind);
        if (vmKind == 13) {
            StaticSerialization.writeString((String)this.memberData.getUniqueTag(), (DataOutput)out);
        } else {
            StaticSerialization.writeString((String)String.valueOf(this.memberData.getVmViewId()), (DataOutput)out);
        }
        StaticSerialization.writeString((String)this.memberData.getName(), (DataOutput)out);
        Version outputVersion = StaticSerialization.getVersionForDataStream((DataOutput)out);
        if (0 <= outputVersion.compareTo((VersionOrdinal)Version.GFE_90) && outputVersion.compareTo((VersionOrdinal)Version.GEODE_1_1_0) < 0) {
            this.memberData.writeAdditionalData(out);
        }
    }

    @Override
    public void setPort(int p) {
        assert (this.memberData.getVmKind() == 13);
        this.memberData.setPort(p);
        this.cachedToString = null;
    }

    @Override
    public MemberData getMemberData() {
        return this.memberData;
    }

    @Override
    public String getHostName() {
        return this.memberData.getHostName();
    }

    @Override
    public String getHost() {
        return this.memberData.getInetAddress().getCanonicalHostName();
    }

    @Override
    public int getProcessId() {
        return this.memberData.getProcessId();
    }

    @Override
    public String getId() {
        return this.toString();
    }

    @Override
    public String getUniqueId() {
        StringBuilder sb = new StringBuilder();
        this.addFixedToString(sb, false);
        short version = this.memberData.getVersionOrdinal();
        if (version != Version.CURRENT.ordinal()) {
            sb.append("(version:").append(Versioning.getVersionOrdinal((short)version)).append(')');
        }
        return sb.toString();
    }

    @Override
    public void setVersionObjectForTest(Version v) {
        this.memberData.setVersion(v);
        this.cachedToString = null;
    }

    @Override
    public VersionOrdinal getVersionOrdinalObject() {
        return this.memberData.getVersionOrdinalObject();
    }

    public Version[] getSerializationVersions() {
        return dsfidVersions;
    }

    @Override
    @VisibleForTesting
    public void setUniqueTag(String tag) {
        this.memberData.setUniqueTag(tag);
    }

    @Override
    public void setIsPartial(boolean value) {
        this.memberData.setIsPartial(value);
    }

    @Override
    public long getUuidLeastSignificantBits() {
        return this.memberData.getUuidLeastSignificantBits();
    }

    @Override
    public long getUuidMostSignificantBits() {
        return this.memberData.getUuidMostSignificantBits();
    }

    @Override
    public boolean isNetworkPartitionDetectionEnabled() {
        return this.memberData.isNetworkPartitionDetectionEnabled();
    }

    @Override
    public void setUUID(UUID uuid) {
        this.memberData.setUUID(uuid);
    }

    @Override
    public void setMemberWeight(byte b) {
        this.memberData.setMemberWeight(b);
    }

    @Override
    public void setUdpPort(int port) {
        this.memberData.setUdpPort(port);
    }

    @Override
    public UUID getUUID() {
        return this.memberData.getUUID();
    }
}

