/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package org.apache.geode.management.runtime;

import static org.assertj.core.api.Assertions.assertThat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Test;

import org.apache.geode.util.internal.GeodeJsonMapper;

public class DeploymentInfoTest {

  @Test
  public void remembersLastModified() {
    DeploymentInfo deploymentInfo = new DeploymentInfo();
    deploymentInfo.setLastModified("lastModified");
    assertThat(deploymentInfo.getLastModified()).isEqualTo("lastModified");
  }

  @Test
  public void remembersJarLocation() {
    DeploymentInfo deploymentInfo = new DeploymentInfo();
    deploymentInfo.setJarLocation("jarLocation");
    assertThat(deploymentInfo.getJarLocation()).isEqualTo("jarLocation");
  }

  @Test
  public void jsonSerializationRoundTrip() throws JsonProcessingException {
    ObjectMapper mapper = GeodeJsonMapper.getMapper();
    DeploymentInfo deploymentInfo = new DeploymentInfo();
    deploymentInfo.setJarLocation("jarLocation");
    deploymentInfo.setLastModified("lastModified");
    String json = mapper.writeValueAsString(deploymentInfo);
    DeploymentInfo newValue = mapper.readValue(json, DeploymentInfo.class);
    assertThat(newValue).isEqualToComparingFieldByField(deploymentInfo);
  }

}
