/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.yarn;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import org.apache.fluo.yarn.FluoYarnProperties;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class FluoYarnEnv {
    private Properties props;
    private String applicationName;
    private String connPropsPath;
    private String logPropsPath;
    private String bundledJarPath = null;
    private YarnConfiguration yarnConfig = null;

    public FluoYarnEnv(String yarnProps, String connProps, String logProps, String appName, String jarPath) {
        Objects.requireNonNull(yarnProps);
        Objects.requireNonNull(connProps);
        Objects.requireNonNull(logProps);
        Objects.requireNonNull(appName);
        Objects.requireNonNull(jarPath);
        FluoYarnEnv.verifyPath(connProps);
        FluoYarnEnv.verifyPath(yarnProps);
        FluoYarnEnv.verifyPath(logProps);
        FluoYarnEnv.verifyPath(jarPath);
        this.props = FluoYarnProperties.loadFromFile(yarnProps);
        this.connPropsPath = connProps;
        this.logPropsPath = logProps;
        this.applicationName = appName;
        this.bundledJarPath = jarPath;
    }

    public String getBundledJarPath() {
        return this.bundledJarPath;
    }

    public String getBundledJarName() {
        return Paths.get(this.getBundledJarPath(), new String[0]).getFileName().toString();
    }

    public String getLogPropsPath() {
        return this.logPropsPath;
    }

    public String getConnPropsPath() {
        return this.connPropsPath;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private static void verifyPath(String path) {
        File f = new File(path);
        Preconditions.checkState((boolean)f.exists());
        Preconditions.checkState((boolean)f.canRead());
    }

    public YarnConfiguration getYarnConfiguration() {
        if (this.yarnConfig == null) {
            this.yarnConfig = new YarnConfiguration();
            this.yarnConfig.set("mapreduce.framework.name", "yarn");
            this.yarnConfig.set("yarn.resourcemanager.hostname", this.getYarnResourceManager());
            this.yarnConfig.set("fs.defaultFS", this.getDfsRoot());
        }
        return this.yarnConfig;
    }

    public String getYarnResourceManager() {
        return this.props.getProperty("fluo.yarn.resource.manager", "localhost");
    }

    public String getZookeepers() {
        return this.props.getProperty("fluo.yarn.zookeepers", "localhost/fluo-yarn");
    }

    public String getDfsRoot() {
        return this.props.getProperty("fluo.yarn.dfs.root", "hdfs://localhost:8020/");
    }

    public int getWorkerCores() {
        return Integer.valueOf(this.props.getProperty("fluo.yarn.worker.num.cores", "1"));
    }

    public int getWorkerInstances() {
        return Integer.valueOf(this.props.getProperty("fluo.yarn.worker.instances", "1"));
    }

    public int getWorkerMaxMemory() {
        return Integer.valueOf(this.props.getProperty("fluo.yarn.worker.max.memory.mb", "1024"));
    }

    public String getWorkerReservedMemory() {
        String rmem = this.props.getProperty("fluo.yarn.worker.reserved.memory.mb", null);
        if (rmem == null) {
            return rmem;
        }
        Preconditions.checkArgument((Integer.parseInt(rmem) > 0 ? 1 : 0) != 0);
        return rmem;
    }

    public int getOracleCores() {
        return Integer.valueOf(this.props.getProperty("fluo.yarn.oracle.num.cores", "1"));
    }

    public int getOracleInstances() {
        return Integer.valueOf(this.props.getProperty("fluo.yarn.oracle.instances", "1"));
    }

    public int getOracleMaxMemory() {
        return Integer.valueOf(this.props.getProperty("fluo.yarn.oracle.max.memory.mb", "512"));
    }

    public String getOracleReservedMemory() {
        String rmem = this.props.getProperty("fluo.yarn.oracle.reserved.memory.mb", null);
        if (rmem == null) {
            return rmem;
        }
        Preconditions.checkArgument((Integer.parseInt(rmem) > 0 ? 1 : 0) != 0);
        return rmem;
    }

    public String getYarnQueue() {
        return this.props.getProperty("fluo.yarn.queue", null);
    }

    public int getTotalInstances() {
        return this.getOracleInstances() + this.getWorkerInstances();
    }
}

