/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.ShowCreateUtil;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ShowOperation;

@Internal
public class ShowCreateModelOperation
implements ShowOperation {
    private final ObjectIdentifier modelIdentifier;
    private final ResolvedCatalogModel model;
    private final boolean isTemporary;

    public ShowCreateModelOperation(ObjectIdentifier sqlIdentifier, ResolvedCatalogModel model, boolean isTemporary) {
        this.modelIdentifier = sqlIdentifier;
        this.model = model;
        this.isTemporary = isTemporary;
    }

    public ResolvedCatalogModel getModel() {
        return this.model;
    }

    @Override
    public String asSummaryString() {
        return String.format("SHOW CREATE MODEL %s", this.modelIdentifier.asSummaryString());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        String resultRow = ShowCreateUtil.buildShowCreateModelRow(this.model, this.modelIdentifier, this.isTemporary);
        return TableResultUtils.buildStringArrayResult("result", new String[]{resultRow});
    }
}

