/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.AuthConstant;
import com.aliyuncs.auth.BasicCredentials;
import com.aliyuncs.auth.CredentialsProviderFactory;
import com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.auth.STSAssumeRoleSessionCredentialsProvider;
import com.aliyuncs.auth.STSGetSessionAccessKeyCredentialsProvider;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.utils.AuthUtils;
import com.aliyuncs.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class ProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private static volatile Wini ini;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Wini getIni(String filePath) throws IOException {
        if (null != ini) return ini;
        Class<ProfileCredentialsProvider> clazz = ProfileCredentialsProvider.class;
        synchronized (ProfileCredentialsProvider.class) {
            if (null != ini) return ini;
            ini = new Wini(new File(filePath));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ini;
        }
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        Wini ini;
        String filePath = AuthUtils.getEnvironmentCredentialsFile();
        if (filePath == null) {
            filePath = AuthConstant.DEFAULT_CREDENTIALS_FILE_PATH;
        }
        if (filePath.length() == 0) {
            throw new ClientException("The specified credentials file is empty");
        }
        try {
            ini = ProfileCredentialsProvider.getIni(filePath);
        }
        catch (IOException e) {
            return null;
        }
        Map<String, Map<String, String>> client = this.loadIni(ini);
        Map<String, String> clientConfig = client.get(AuthUtils.getClientType());
        if (clientConfig == null) {
            throw new ClientException("Client is not open in the specified credentials file");
        }
        CredentialsProviderFactory credentialsProviderFactory = new CredentialsProviderFactory();
        return this.createCredential(clientConfig, credentialsProviderFactory);
    }

    private Map<String, Map<String, String>> loadIni(Wini ini) {
        HashMap<String, Map<String, String>> client = new HashMap<String, Map<String, String>>();
        for (Map.Entry clientType : ini.entrySet()) {
            boolean enable = ((Profile.Section)clientType.getValue()).get((Object)"enable", Boolean.TYPE);
            if (!enable) continue;
            HashMap clientConfig = new HashMap();
            for (Map.Entry enabledClient : ((Profile.Section)clientType.getValue()).entrySet()) {
                clientConfig.put(enabledClient.getKey(), enabledClient.getValue());
            }
            client.put((String)clientType.getKey(), clientConfig);
        }
        return client;
    }

    private AlibabaCloudCredentials createCredential(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws ClientException {
        String configType = clientConfig.get("type");
        if (StringUtils.isEmpty(configType)) {
            throw new ClientException("The configured client type is empty");
        }
        if ("ram_role_arn".equals(configType)) {
            return this.getSTSAssumeRoleSessionCredentials(clientConfig, factory);
        }
        if ("rsa_key_pair".equals(configType)) {
            return this.getSTSGetSessionAccessKeyCredentials(clientConfig, factory);
        }
        if ("ecs_ram_role".equals(configType)) {
            return this.getInstanceProfileCredentials(clientConfig, factory);
        }
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            return null;
        }
        return new BasicCredentials(accessKeyId, accessKeySecret);
    }

    private AlibabaCloudCredentials getSTSAssumeRoleSessionCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws ClientException {
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        String roleSessionName = clientConfig.get("role_session_name");
        String roleArn = clientConfig.get("role_arn");
        String regionId = clientConfig.get("region_id");
        String policy = clientConfig.get("policy");
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            throw new ClientException("The configured access_key_id or access_key_secret is empty");
        }
        if (StringUtils.isEmpty(roleSessionName) || StringUtils.isEmpty(roleArn)) {
            throw new ClientException("The configured role_session_name or role_arn is empty");
        }
        STSAssumeRoleSessionCredentialsProvider provider = factory.createCredentialsProvider(new STSAssumeRoleSessionCredentialsProvider(accessKeyId, accessKeySecret, roleSessionName, roleArn, regionId, policy));
        return provider.getCredentials();
    }

    private AlibabaCloudCredentials getSTSGetSessionAccessKeyCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws ClientException {
        String publicKeyId = clientConfig.get("public_key_id");
        String privateKeyFile = clientConfig.get("private_key_file");
        if (StringUtils.isEmpty(privateKeyFile)) {
            throw new ClientException("The configured private_key_file is empty");
        }
        String privateKey = AuthUtils.getPrivateKey(privateKeyFile);
        if (StringUtils.isEmpty(publicKeyId) || StringUtils.isEmpty(privateKey)) {
            throw new ClientException("The configured public_key_id or private_key_file content is empty");
        }
        STSGetSessionAccessKeyCredentialsProvider provider = factory.createCredentialsProvider(new STSGetSessionAccessKeyCredentialsProvider(publicKeyId, privateKey));
        return provider.getCredentials();
    }

    private AlibabaCloudCredentials getInstanceProfileCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws ClientException {
        String roleName = clientConfig.get("role_name");
        if (StringUtils.isEmpty(roleName)) {
            throw new ClientException("The configured role_name is empty");
        }
        InstanceProfileCredentialsProvider provider = factory.createCredentialsProvider(new InstanceProfileCredentialsProvider(roleName));
        return provider.getCredentials();
    }
}

