/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.functions.async.AsyncRetryStrategy;
import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.calc.async.RetryPredicates;

public class AsyncUtil {
    public static boolean containsAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(true, true));
    }

    public static boolean containsNonAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(false, true));
    }

    public static boolean isAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(true, false));
    }

    public static boolean isNonAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(false, false));
    }

    public static Options getAsyncOptions(ExecNodeConfig config) {
        return new Options((Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_BUFFER_CAPACITY), ((Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_TIMEOUT)).toMillis(), AsyncDataStream.OutputMode.ORDERED, AsyncUtil.getResultRetryStrategy((ExecutionConfigOptions.RetryStrategy)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_RETRY_STRATEGY), (Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_RETRY_DELAY), (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_MAX_ATTEMPTS)));
    }

    private static AsyncRetryStrategy<RowData> getResultRetryStrategy(ExecutionConfigOptions.RetryStrategy retryStrategy, Duration retryDelay, int retryMaxAttempts) {
        if (retryStrategy == ExecutionConfigOptions.RetryStrategy.FIXED_DELAY) {
            return new AsyncRetryStrategies.FixedDelayRetryStrategyBuilder(retryMaxAttempts, retryDelay.toMillis()).ifResult((Predicate)RetryPredicates.EMPTY_RESPONSE).ifException(RetryPredicates.ANY_EXCEPTION).build();
        }
        return AsyncRetryStrategies.NO_RETRY_STRATEGY;
    }

    private static class FunctionFinder
    extends RexDefaultVisitor<Boolean> {
        private final boolean findAsyncCall;
        private final boolean recursive;

        public FunctionFinder(boolean findAsyncCall, boolean recursive) {
            this.findAsyncCall = findAsyncCall;
            this.recursive = recursive;
        }

        @Override
        public Boolean visitNode(RexNode rexNode) {
            return false;
        }

        private boolean isImmediateAsyncCall(RexCall call) {
            FunctionDefinition definition = ShortcutUtils.unwrapFunctionDefinition(call);
            return definition != null && definition.getKind() == FunctionKind.ASYNC_SCALAR;
        }

        @Override
        public Boolean visitCall(RexCall call) {
            boolean isImmediateAsyncCall = this.isImmediateAsyncCall(call);
            return this.findAsyncCall == isImmediateAsyncCall || this.recursive && call.getOperands().stream().anyMatch(node -> node.accept(this));
        }
    }

    public static class Options {
        public final int asyncBufferCapacity;
        public final long asyncTimeout;
        public final AsyncDataStream.OutputMode asyncOutputMode;
        public final AsyncRetryStrategy<RowData> asyncRetryStrategy;

        public Options(int asyncBufferCapacity, long asyncTimeout, AsyncDataStream.OutputMode asyncOutputMode, AsyncRetryStrategy<RowData> asyncRetryStrategy) {
            this.asyncBufferCapacity = asyncBufferCapacity;
            this.asyncTimeout = asyncTimeout;
            this.asyncOutputMode = asyncOutputMode;
            this.asyncRetryStrategy = asyncRetryStrategy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Options that = (Options)o;
            return this.asyncBufferCapacity == that.asyncBufferCapacity && this.asyncTimeout == that.asyncTimeout && this.asyncOutputMode == that.asyncOutputMode;
        }

        public int hashCode() {
            return Objects.hash(this.asyncBufferCapacity, this.asyncTimeout, this.asyncOutputMode);
        }

        public String toString() {
            return this.asyncOutputMode + ", " + this.asyncTimeout + "ms, " + this.asyncBufferCapacity;
        }
    }
}

