/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.table.planner.functions.sql.internal.SqlAuxiliaryGroupAggFunction;

public class FlinkAggregateRemoveRule
extends RelOptRule {
    public static final FlinkAggregateRemoveRule INSTANCE = new FlinkAggregateRemoveRule(LogicalAggregate.class, RelFactories.LOGICAL_BUILDER);

    @Deprecated
    public FlinkAggregateRemoveRule(Class<? extends Aggregate> aggregateClass) {
        this(aggregateClass, RelFactories.LOGICAL_BUILDER);
    }

    public FlinkAggregateRemoveRule(Class<? extends Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory) {
        super(FlinkAggregateRemoveRule.operand(aggregateClass, FlinkAggregateRemoveRule.operand(RelNode.class, FlinkAggregateRemoveRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Object input = call.rel(1);
        if (aggregate.getGroupCount() == 0 || aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            return false;
        }
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            boolean isAllowAggCall;
            SqlKind aggCallKind = aggCall.getAggregation().getKind();
            boolean bl = isAllowAggCall = aggCallKind == SqlKind.SUM || aggCallKind == SqlKind.MIN || aggCallKind == SqlKind.MAX || aggCall.getAggregation() instanceof SqlAuxiliaryGroupAggFunction;
            if (isAllowAggCall && aggCall.filterArg < 0 && aggCall.getArgList().size() == 1) continue;
            return false;
        }
        RelMetadataQuery mq = call.getMetadataQuery();
        return SqlFunctions.isTrue(mq.areColumnsUnique((RelNode)input, aggregate.getGroupSet()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Object input = call.rel(1);
        RelNode newInput = FlinkAggregateRemoveRule.convert(input, aggregate.getTraitSet().simplify());
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newInput);
        ArrayList<Integer> projectIndices = new ArrayList<Integer>(aggregate.getGroupSet().asList());
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            projectIndices.addAll(aggCall.getArgList());
        }
        relBuilder.project(relBuilder.fields((List<? extends Number>)projectIndices));
        relBuilder.convert(aggregate.getRowType(), true);
        call.transformTo(relBuilder.build());
    }
}

