/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="SliceAttached")
public class SliceAttachedWindowingStrategy
extends WindowingStrategy {
    public static final String FIELD_NAME_SLICE_END = "sliceEnd";
    @JsonProperty(value="sliceEnd")
    private final int sliceEnd;

    @JsonCreator
    public SliceAttachedWindowingStrategy(@JsonProperty(value="window") WindowSpec window, @JsonProperty(value="timeAttributeType") LogicalType timeAttributeType, @JsonProperty(value="sliceEnd") int sliceEnd) {
        super(window, timeAttributeType);
        Preconditions.checkArgument((sliceEnd >= 0 ? 1 : 0) != 0);
        this.sliceEnd = sliceEnd;
    }

    @Override
    public String toSummaryString(String[] inputFieldNames) {
        Preconditions.checkArgument((this.sliceEnd < inputFieldNames.length ? 1 : 0) != 0);
        String windowing = String.format("slice_end=[%s]", inputFieldNames[this.sliceEnd]);
        return this.window.toSummaryString(windowing, inputFieldNames);
    }

    public int getSliceEnd() {
        return this.sliceEnd;
    }
}

