/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.core.InternalApi;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

@InternalApi
public class HttpHeadersUtils {
    public static String getUserAgentValue(Map<String, String> headersMap) {
        for (Map.Entry<String, String> entry : headersMap.entrySet()) {
            if (!"user-agent".equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static HttpHeaders setHeaders(HttpHeaders headers, Map<String, String> headersMap) {
        for (Map.Entry<String, String> entry : headersMap.entrySet()) {
            HttpHeadersUtils.setHeader(headers, entry.getKey(), entry.getValue());
        }
        return headers;
    }

    public static HttpHeaders setHeader(HttpHeaders headers, String key, String value) {
        Object headerValue;
        ClassInfo classInfo = headers.getClassInfo();
        FieldInfo fieldInfo = classInfo.getFieldInfo(key);
        if (fieldInfo == null) {
            headerValue = value;
        } else {
            Class<Object> elementyType = fieldInfo.getType();
            if (List.class.isAssignableFrom(fieldInfo.getType())) {
                elementyType = "Age".equalsIgnoreCase(key) || "Content-Length".equalsIgnoreCase(key) ? Long.class : String.class;
            }
            headerValue = ImmutableList.of(HttpHeadersUtils.fromString(elementyType, value));
        }
        headers.set(key, headerValue);
        return headers;
    }

    private static Object fromString(Class<?> clazz, String stringValue) {
        if (String.class == clazz) {
            return stringValue;
        }
        if (Long.class == clazz) {
            return Long.valueOf(stringValue);
        }
        throw new IllegalArgumentException("Instantiating " + clazz + " from string representation is not supported. Most likely an incompatible version of google-http-client was used.");
    }
}

