/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.NotFoundInstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.profiler.context.scope.ConcurrentPool;
import com.navercorp.pinpoint.profiler.context.scope.InterceptorScopeFactory;
import com.navercorp.pinpoint.profiler.context.scope.Pool;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.instrument.scanner.ClassScannerFactory;
import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerDelegate;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerLoader;
import com.navercorp.pinpoint.profiler.plugin.DynamicTransformCallbackProvider;
import com.navercorp.pinpoint.profiler.plugin.InstanceTransformCallbackProvider;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginInstrumentContext
implements InstrumentContext {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final ClassInjector classInjector;
    private final Pool<String, InterceptorScope> interceptorScopePool = new ConcurrentPool<String, InterceptorScope>(new InterceptorScopeFactory());
    private final ClassFileTransformerLoader transformerRegistry;

    public PluginInstrumentContext(ProfilerConfig profilerConfig, InstrumentEngine instrumentEngine, DynamicTransformTrigger dynamicTransformTrigger, ClassInjector classInjector, ClassFileTransformerLoader transformerRegistry) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.instrumentEngine = Objects.requireNonNull(instrumentEngine, "instrumentEngine");
        this.dynamicTransformTrigger = Objects.requireNonNull(dynamicTransformTrigger, "dynamicTransformTrigger");
        this.classInjector = Objects.requireNonNull(classInjector, "classInjector");
        this.transformerRegistry = Objects.requireNonNull(transformerRegistry, "transformerRegistry");
    }

    public InstrumentClass getInstrumentClass(ClassLoader classLoader, String className, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        Objects.requireNonNull(className, "className");
        try {
            InstrumentEngine instrumentEngine = this.getInstrumentEngine();
            return instrumentEngine.getClass(this, classLoader, className, protectionDomain, classFileBuffer);
        }
        catch (NotFoundInstrumentException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(ClassLoader classLoader, String className, ProtectionDomain protectionDomain) {
        Objects.requireNonNull(className, "className");
        String jvmClassName = JavaAssistUtils.javaClassNameToJvmResourceName(className);
        Scanner scanner = ClassScannerFactory.newScanner(protectionDomain, classLoader);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("scanner:{}", (Object)scanner);
        }
        try {
            boolean bl = scanner.exist(jvmClassName);
            return bl;
        }
        finally {
            scanner.close();
        }
    }

    private InstrumentEngine getInstrumentEngine() {
        return this.instrumentEngine;
    }

    public void addClassFileTransformer(Matcher matcher, TransformCallback transformCallback) {
        Objects.requireNonNull(matcher, "matcher");
        Objects.requireNonNull(transformCallback, "transformCallback");
        InstanceTransformCallbackProvider transformCallbackProvider = new InstanceTransformCallbackProvider(transformCallback);
        this.transformerRegistry.addClassFileTransformer(this, matcher, transformCallbackProvider);
    }

    public void addClassFileTransformer(Matcher matcher, String transformCallbackClassName) {
        Objects.requireNonNull(matcher, "matcher");
        Objects.requireNonNull(transformCallbackClassName, "transformCallbackClassName");
        DynamicTransformCallbackProvider transformCallbackProvider = new DynamicTransformCallbackProvider(transformCallbackClassName);
        this.transformerRegistry.addClassFileTransformer(this, matcher, transformCallbackProvider);
    }

    public void addClassFileTransformer(Matcher matcher, String transformCallbackClassName, Object[] parameters, Class<?>[] parameterTypes) {
        Objects.requireNonNull(matcher, "matcher");
        Objects.requireNonNull(transformCallbackClassName, "transformCallbackClassName");
        DynamicTransformCallbackProvider transformCallbackProvider = new DynamicTransformCallbackProvider(transformCallbackClassName, parameters, parameterTypes);
        this.transformerRegistry.addClassFileTransformer(this, matcher, transformCallbackProvider);
    }

    public void addClassFileTransformer(ClassLoader classLoader, String targetClassName, TransformCallback transformCallback) {
        Objects.requireNonNull(targetClassName, "targetClassName");
        Objects.requireNonNull(transformCallback, "transformCallback");
        InstanceTransformCallbackProvider transformCallbackProvider = new InstanceTransformCallbackProvider(transformCallback);
        this.transformerRegistry.addClassFileTransformer(this, classLoader, targetClassName, transformCallbackProvider);
    }

    public void addClassFileTransformer(ClassLoader classLoader, String targetClassName, String transformCallbackClassName) {
        Objects.requireNonNull(targetClassName, "targetClassName");
        Objects.requireNonNull(transformCallbackClassName, "transformCallbackClassName");
        DynamicTransformCallbackProvider transformCallbackProvider = new DynamicTransformCallbackProvider(transformCallbackClassName);
        this.transformerRegistry.addClassFileTransformer(this, classLoader, targetClassName, transformCallbackProvider);
    }

    public void retransform(Class<?> target, TransformCallback transformCallback) {
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(transformCallback, "transformCallback");
        InstanceTransformCallbackProvider transformCallbackProvider = new InstanceTransformCallbackProvider(transformCallback);
        ClassFileTransformerDelegate classFileTransformerGuardDelegate = new ClassFileTransformerDelegate(this.profilerConfig, this, transformCallbackProvider);
        this.dynamicTransformTrigger.retransform(target, (ClassFileTransformer)classFileTransformerGuardDelegate);
    }

    public <T> Class<? extends T> injectClass(ClassLoader targetClassLoader, String className) {
        Objects.requireNonNull(className, "className");
        return this.classInjector.injectClass(targetClassLoader, className);
    }

    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String classPath) {
        if (classPath == null) {
            return null;
        }
        return this.classInjector.getResourceAsStream(targetClassLoader, classPath);
    }

    public InterceptorScope getInterceptorScope(String name) {
        Objects.requireNonNull(name, "name");
        return this.interceptorScopePool.get(name);
    }
}

