/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.metadata.CachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.ParsingResultInternal;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlCacheService<ID> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final CachingSqlNormalizer<ParsingResultInternal<ID>> cachingSqlNormalizer;
    private final EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender;

    public SqlCacheService(EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender, CachingSqlNormalizer<ParsingResultInternal<ID>> cachingSqlNormalizer) {
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        this.cachingSqlNormalizer = Objects.requireNonNull(cachingSqlNormalizer, "cachingSqlNormalizer");
    }

    public boolean cacheSql(ParsingResultInternal<ID> parsingResult, Function<ParsingResultInternal<ID>, MetaDataType> converter) {
        if (parsingResult == null) {
            return false;
        }
        boolean isNewValue = this.cachingSqlNormalizer.normalizedSql(parsingResult);
        if (isNewValue) {
            if (this.isDebug) {
                this.logger.debug("update sql cache {}", parsingResult);
            }
            MetaDataType sqlMetaData = converter.apply(parsingResult);
            this.enhancedDataSender.request((Object)sqlMetaData);
        } else if (this.isDebug) {
            this.logger.debug("cache hit {}", parsingResult);
        }
        return isNewValue;
    }
}

