/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapClassLoaderHandler;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.instrument.classloading.PlainClassLoaderHandler;
import com.navercorp.pinpoint.profiler.instrument.classloading.URLClassLoaderHandler;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JarProfilerPluginClassInjector
implements ClassInjector {
    private final Logger logger = LogManager.getLogger(JarProfilerPluginClassInjector.class);
    private final BootstrapCore bootstrapCore;
    private final ClassInjector bootstrapClassLoaderHandler;
    private final ClassInjector urlClassLoaderHandler;
    private final ClassInjector plainClassLoaderHandler;

    public JarProfilerPluginClassInjector(PluginConfig pluginConfig, InstrumentEngine instrumentEngine, BootstrapCore bootstrapCore) {
        Objects.requireNonNull(pluginConfig, "pluginConfig");
        this.bootstrapCore = Objects.requireNonNull(bootstrapCore, "bootstrapCore");
        this.bootstrapClassLoaderHandler = new BootstrapClassLoaderHandler(pluginConfig, instrumentEngine);
        this.urlClassLoaderHandler = new URLClassLoaderHandler(pluginConfig);
        this.plainClassLoaderHandler = new PlainClassLoaderHandler(pluginConfig);
    }

    @Override
    public <T> Class<? extends T> injectClass(ClassLoader classLoader, String className) {
        try {
            if (this.bootstrapCore.isBootstrapPackage(className)) {
                return this.bootstrapCore.loadClass(className);
            }
            if (classLoader == null) {
                return this.bootstrapClassLoaderHandler.injectClass(null, className);
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                return this.urlClassLoaderHandler.injectClass(urlClassLoader, className);
            }
            return this.plainClassLoaderHandler.injectClass(classLoader, className);
        }
        catch (Throwable e) {
            this.logger.warn("Failed to load plugin class {} with classLoader {}", (Object)className, (Object)classLoader, (Object)e);
            throw new PinpointException("Failed to load plugin class " + className + " with classLoader " + classLoader, e);
        }
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String internalName) {
        try {
            if (this.bootstrapCore.isBootstrapPackageByInternalName(internalName)) {
                return this.bootstrapCore.openStream(internalName);
            }
            if (targetClassLoader == null) {
                return this.bootstrapClassLoaderHandler.getResourceAsStream(null, internalName);
            }
            if (targetClassLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)targetClassLoader;
                return this.urlClassLoaderHandler.getResourceAsStream(urlClassLoader, internalName);
            }
            return this.plainClassLoaderHandler.getResourceAsStream(targetClassLoader, internalName);
        }
        catch (Throwable e) {
            this.logger.warn("Failed to load plugin resource as stream {} with classLoader {}", (Object)internalName, (Object)targetClassLoader, (Object)e);
            return null;
        }
    }
}

