/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.metadata;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.cache.SimpleCache;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.provider.metadata.SimpleCacheFactory;
import com.navercorp.pinpoint.profiler.metadata.DefaultStringMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import java.util.Objects;

public class StringMetadataServiceProvider
implements Provider<StringMetaDataService> {
    private final EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender;
    private final SimpleCacheFactory simpleCacheFactory;

    @Inject
    public StringMetadataServiceProvider(@MetadataDataSender EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender, SimpleCacheFactory simpleCacheFactory) {
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        this.simpleCacheFactory = Objects.requireNonNull(simpleCacheFactory, "simpleCacheFactory");
    }

    public StringMetaDataService get() {
        SimpleCache<String> stringCache = this.simpleCacheFactory.newSimpleCache();
        return new DefaultStringMetaDataService(this.enhancedDataSender, stringCache);
    }
}

