/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentStatMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.CustomMetricMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.UriStatMapper;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentCustomMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import java.util.Objects;

public class GrpcStatMessageConverter
implements MessageConverter<MetricType, GeneratedMessageV3> {
    private final AgentStatMapper agentStatMapper;
    private final CustomMetricMapper customMetricMapper;
    private final UriStatMapper uriStatMapper;

    public GrpcStatMessageConverter(AgentStatMapper agentStatMapper, CustomMetricMapper customMetricMapper, UriStatMapper uriStatMapper) {
        this.agentStatMapper = Objects.requireNonNull(agentStatMapper, "agentStatMapper");
        this.customMetricMapper = Objects.requireNonNull(customMetricMapper, "customMetricMapper");
        this.uriStatMapper = Objects.requireNonNull(uriStatMapper, "uriStatMapper");
    }

    public GeneratedMessageV3 toMessage(MetricType message) {
        if (message instanceof AgentStatMetricSnapshotBatch) {
            AgentStatMetricSnapshotBatch agentStatMetricSnapshotBatch = (AgentStatMetricSnapshotBatch)message;
            return this.agentStatMapper.map(agentStatMetricSnapshotBatch);
        }
        if (message instanceof AgentStatMetricSnapshot) {
            AgentStatMetricSnapshot agentStatMetricSnapshot = (AgentStatMetricSnapshot)message;
            return this.agentStatMapper.map(agentStatMetricSnapshot);
        }
        if (message instanceof AgentCustomMetricSnapshotBatch) {
            AgentCustomMetricSnapshotBatch agentCustomMetricSnapshotBatch = (AgentCustomMetricSnapshotBatch)message;
            return this.customMetricMapper.map(agentCustomMetricSnapshotBatch);
        }
        if (message instanceof AgentUriStatData) {
            AgentUriStatData agentUriStatData = (AgentUriStatData)message;
            return this.uriStatMapper.map(agentUriStatData);
        }
        return null;
    }
}

