/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.flowcontrol;

import com.navercorp.pinpoint.common.profiler.logging.ThrottledLogger;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.grpc.Header;
import com.navercorp.pinpoint.grpc.server.flowcontrol.DefaultServerCallWrapper;
import com.navercorp.pinpoint.grpc.server.flowcontrol.RejectedExecutionListenerFactory;
import com.navercorp.pinpoint.grpc.server.flowcontrol.ScheduledExecutor;
import com.navercorp.pinpoint.grpc.server.flowcontrol.ServerCallWrapper;
import com.navercorp.pinpoint.grpc.server.flowcontrol.StreamExecutorRejectedExecutionRequestScheduler;
import io.grpc.Context;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamExecutorServerInterceptor
implements ServerInterceptor {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ThrottledLogger throttledLogger;
    private final String name;
    private final Executor executor;
    private final int initNumMessages;
    private final StreamExecutorRejectedExecutionRequestScheduler scheduler;

    public StreamExecutorServerInterceptor(String name, Executor executor, int initNumMessages, ScheduledExecutor scheduledExecutor, RejectedExecutionListenerFactory listenerFactory, long throttledLoggerRatio) {
        this.name = Objects.requireNonNull(name, "name");
        Objects.requireNonNull(executor, "executor");
        this.executor = Context.currentContextExecutor((Executor)executor);
        Assert.isTrue((initNumMessages > 0 ? 1 : 0) != 0, (String)"initNumMessages must be positive");
        this.initNumMessages = initNumMessages;
        Objects.requireNonNull(scheduledExecutor, "scheduledExecutor");
        Objects.requireNonNull(listenerFactory, "listenerFactory");
        this.scheduler = new StreamExecutorRejectedExecutionRequestScheduler(scheduledExecutor, listenerFactory);
        this.throttledLogger = ThrottledLogger.getLogger((Logger)this.logger, (long)throttledLoggerRatio);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCallWrapper serverCall = this.newServerCallWrapper(call, headers);
        final StreamExecutorRejectedExecutionRequestScheduler.Listener scheduleListener = this.scheduler.schedule(serverCall);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initialize schedule listener. {} {}, headers={}, initNumMessages={}, scheduler={}, listener={}", (Object)this.name, (Object)call.getMethodDescriptor().getFullMethodName(), (Object)headers, (Object)this.initNumMessages, (Object)this.scheduler, (Object)scheduleListener);
        }
        ServerCall.Listener listener = next.startCall(call, headers);
        call.request(this.initNumMessages);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listener){

            public void onMessage(final ReqT message) {
                try {
                    StreamExecutorServerInterceptor.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            scheduleListener.onMessage();
                            this.delegate().onMessage(message);
                        }
                    });
                }
                catch (RejectedExecutionException ree) {
                    scheduleListener.onRejectedExecution();
                    StreamExecutorServerInterceptor.this.throttledLogger.info("Failed to request. Rejected execution, count={}", (Object)scheduleListener.getRejectedExecutionCount());
                }
            }

            public void onCancel() {
                scheduleListener.onCancel();
                this.delegate().onCancel();
            }

            public void onComplete() {
                scheduleListener.onCancel();
                this.delegate().onComplete();
            }
        };
    }

    private <ReqT, RespT> ServerCallWrapper newServerCallWrapper(ServerCall<ReqT, RespT> call, Metadata headers) {
        String agentId = (String)headers.get(Header.AGENT_ID_KEY);
        String applicationName = (String)headers.get(Header.APPLICATION_NAME_KEY);
        return new DefaultServerCallWrapper<ReqT, RespT>(call, applicationName, agentId);
    }
}

