/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client;

import com.navercorp.pinpoint.grpc.Header;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.concurrent.atomic.AtomicLong;

public class SocketIdClientInterceptor
implements ClientInterceptor {
    private final AtomicLong socketIdAllocator = new AtomicLong();

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall clientCall = next.newCall(method, callOptions);
        ForwardingClientCall.SimpleForwardingClientCall forwardClientCall = new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                String socketId = SocketIdClientInterceptor.this.nextSocketId();
                headers.put(Header.SOCKET_ID, (Object)socketId);
                super.start(responseListener, headers);
            }
        };
        return forwardClientCall;
    }

    private String nextSocketId() {
        return String.valueOf(this.socketIdAllocator.incrementAndGet());
    }
}

