/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.sink.handler.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.net.URI;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.http.SinkConnectorConfig;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.http.sink.data.HttpAttemptEvent;
import org.apache.eventmesh.connector.http.sink.data.HttpConnectRecord;
import org.apache.eventmesh.connector.http.sink.data.MultiHttpRequestContext;
import org.apache.eventmesh.connector.http.sink.handler.AbstractHttpSinkHandler;
import org.apache.eventmesh.connector.http.util.HttpUtils;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendExceptionContext;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendResult;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHttpSinkHandler
extends AbstractHttpSinkHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonHttpSinkHandler.class);
    private WebClient webClient;

    public CommonHttpSinkHandler(SinkConnectorConfig sinkConnectorConfig) {
        super(sinkConnectorConfig);
    }

    @Override
    public void start() {
        this.doInitWebClient();
    }

    private void doInitWebClient() {
        SinkConnectorConfig sinkConnectorConfig = this.getSinkConnectorConfig();
        Vertx vertx = Vertx.vertx();
        WebClientOptions options = new WebClientOptions().setKeepAlive(sinkConnectorConfig.isKeepAlive()).setKeepAliveTimeout(sinkConnectorConfig.getKeepAliveTimeout() / 1000).setIdleTimeout(sinkConnectorConfig.getIdleTimeout()).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setConnectTimeout(sinkConnectorConfig.getConnectionTimeout()).setMaxPoolSize(sinkConnectorConfig.getMaxConnectionPoolSize()).setPipelining(sinkConnectorConfig.isParallelized());
        this.webClient = WebClient.create((Vertx)vertx, (WebClientOptions)options);
    }

    @Override
    public Future<HttpResponse<Buffer>> deliver(URI url, HttpConnectRecord httpConnectRecord, Map<String, Object> attributes, ConnectRecord connectRecord) {
        HashMap<String, Object> extensionMap = new HashMap<String, Object>();
        Set extensionKeySet = httpConnectRecord.getExtensions().keySet();
        for (String extensionKey : extensionKeySet) {
            Object v = httpConnectRecord.getExtensions().getObject(extensionKey);
            extensionMap.put(extensionKey, v);
        }
        MultiMap headers = HttpHeaders.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").set((CharSequence)HttpHeaderNames.ACCEPT, (CharSequence)"application/json; charset=utf-8").set("extension", JsonUtils.toJSONString(extensionMap));
        Long timestamp = httpConnectRecord.getCreateTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return this.webClient.post(url.getPath()).host(url.getHost()).port(url.getPort() == -1 ? (Objects.equals(url.getScheme(), "https") ? 443 : 80) : url.getPort()).putHeaders(headers).ssl(Boolean.valueOf(Objects.equals(url.getScheme(), "https"))).sendJson(httpConnectRecord.getData()).onSuccess(res -> {
            log.info("Request sent successfully. Record: timestamp={}", (Object)timestamp);
            RuntimeException e = null;
            if (HttpUtils.is2xxSuccessful(res.statusCode())) {
                if (log.isDebugEnabled()) {
                    log.debug("Received successful response: statusCode={}. Record: timestamp={}, responseBody={}", new Object[]{res.statusCode(), timestamp, res.bodyAsString()});
                } else {
                    log.info("Received successful response: statusCode={}. Record: timestamp={}", (Object)res.statusCode(), (Object)timestamp);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.warn("Received non-2xx response: statusCode={}. Record: timestamp={}, responseBody={}", new Object[]{res.statusCode(), timestamp, res.bodyAsString()});
                } else {
                    log.warn("Received non-2xx response: statusCode={}. Record: timestamp={}", (Object)res.statusCode(), (Object)timestamp);
                }
                e = new RuntimeException("Unexpected HTTP response code: " + res.statusCode());
            }
            this.tryCallback(httpConnectRecord, e, attributes, connectRecord);
        }).onFailure(err -> {
            log.error("Request failed to send. Record: timestamp={}", (Object)timestamp, err);
            this.tryCallback(httpConnectRecord, (Throwable)err, attributes, connectRecord);
        });
    }

    private void tryCallback(HttpConnectRecord httpConnectRecord, Throwable e, Map<String, Object> attributes, ConnectRecord record) {
        HttpAttemptEvent attemptEvent = (HttpAttemptEvent)attributes.get("http-attempt-event-" + httpConnectRecord.getHttpRecordId());
        attemptEvent.updateEvent(e);
        MultiHttpRequestContext multiHttpRequestContext = this.getAndUpdateMultiHttpRequestContext(attributes, attemptEvent);
        if (multiHttpRequestContext.isAllRequestsProcessed()) {
            if (record.getCallback() == null) {
                if (log.isDebugEnabled()) {
                    log.warn("ConnectRecord callback is null. Ignoring callback. {}", (Object)record);
                } else {
                    log.warn("ConnectRecord callback is null. Ignoring callback.");
                }
                return;
            }
            HttpAttemptEvent lastFailedEvent = multiHttpRequestContext.getLastFailedEvent();
            if (lastFailedEvent == null) {
                record.getCallback().onSuccess(this.convertToSendResult(record));
            } else {
                record.getCallback().onException(this.buildSendExceptionContext(record, lastFailedEvent.getLastException()));
            }
        } else {
            log.warn("still have requests to process, size {}|attempt num {}", (Object)multiHttpRequestContext.getRemainingRequests(), (Object)attemptEvent.getAttempts());
        }
    }

    private MultiHttpRequestContext getAndUpdateMultiHttpRequestContext(Map<String, Object> attributes, HttpAttemptEvent attemptEvent) {
        MultiHttpRequestContext multiHttpRequestContext = (MultiHttpRequestContext)attributes.get("multi-http-request-context");
        if (attemptEvent.isComplete()) {
            multiHttpRequestContext.decrementRemainingRequests();
            if (attemptEvent.getLastException() != null) {
                multiHttpRequestContext.setLastFailedEvent(attemptEvent);
            }
        }
        return multiHttpRequestContext;
    }

    private SendResult convertToSendResult(ConnectRecord record) {
        SendResult result = new SendResult();
        result.setMessageId(record.getRecordId());
        if (StringUtils.isNotEmpty((CharSequence)record.getExtension("topic"))) {
            result.setTopic(record.getExtension("topic"));
        }
        return result;
    }

    private SendExceptionContext buildSendExceptionContext(ConnectRecord record, Throwable e) {
        SendExceptionContext sendExceptionContext = new SendExceptionContext();
        sendExceptionContext.setMessageId(record.getRecordId());
        sendExceptionContext.setCause(e);
        if (StringUtils.isNotEmpty((CharSequence)record.getExtension("topic"))) {
            sendExceptionContext.setTopic(record.getExtension("topic"));
        }
        return sendExceptionContext;
    }

    @Override
    public void stop() {
        if (this.webClient != null) {
            this.webClient.close();
        } else {
            log.warn("WebClient is null, ignore.");
        }
    }

    @Generated
    public WebClient getWebClient() {
        return this.webClient;
    }
}

