/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache.bean;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.management.CacheStatisticsMXBean;

public class JCacheStatisticsMXBean
implements CacheStatisticsMXBean {
    private final AtomicLong removals = new AtomicLong();
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong puts = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();
    private final AtomicLong removeTime = new AtomicLong();
    private final AtomicLong getTime = new AtomicLong();
    private final AtomicLong putTime = new AtomicLong();

    public void clear() {
        this.removals.set(0L);
        this.hits.set(0L);
        this.puts.set(0L);
        this.misses.set(0L);
        this.evictions.set(0L);
        this.removeTime.set(0L);
        this.getTime.set(0L);
        this.putTime.set(0L);
    }

    public void addHits(long value) {
        this.hits.addAndGet(value);
    }

    public long getCacheHits() {
        return this.hits.get();
    }

    public float getCacheHitPercentage() {
        long gets = this.getCacheGets();
        if (gets == 0L) {
            return 0.0f;
        }
        return (float)(this.getCacheHits() * 100L) / (float)gets;
    }

    public void addMisses(long value) {
        this.misses.addAndGet(value);
    }

    public long getCacheMisses() {
        return this.misses.get();
    }

    public float getCacheMissPercentage() {
        long gets = this.getCacheGets();
        if (gets == 0L) {
            return 0.0f;
        }
        return (float)(this.getCacheMisses() * 100L) / (float)gets;
    }

    public long getCacheGets() {
        return this.hits.get() + this.misses.get();
    }

    public void addPuts(long value) {
        this.puts.addAndGet(value);
    }

    public long getCachePuts() {
        return this.puts.get();
    }

    public void addRemovals(long value) {
        this.removals.addAndGet(value);
    }

    public long getCacheRemovals() {
        return this.removals.get();
    }

    public void addEvictions(long value) {
        this.evictions.addAndGet(value);
    }

    public long getCacheEvictions() {
        return this.evictions.get();
    }

    private float get(long value, long timeInNanos) {
        if (value == 0L || timeInNanos == 0L) {
            return 0.0f;
        }
        long timeInMicrosec = TimeUnit.NANOSECONDS.toMicros(timeInNanos);
        return timeInMicrosec / value;
    }

    public void addGetTime(long value) {
        this.getTime.addAndGet(value);
    }

    public float getAverageGetTime() {
        return this.get(this.getCacheGets(), this.getTime.get());
    }

    public void addPutTime(long value) {
        this.putTime.addAndGet(value);
    }

    public float getAveragePutTime() {
        return this.get(this.getCachePuts(), this.putTime.get());
    }

    public void addRemoveTime(long value) {
        this.removeTime.addAndGet(value);
    }

    public float getAverageRemoveTime() {
        return this.get(this.getCachePuts(), this.removeTime.get());
    }
}

