/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.codec.BaseEventCodec;

public class MapCacheEventCodec
extends BaseEventCodec {
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>(3);
            Object key = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapKeyDecoder());
            result.add(key);
            Object value = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapValueDecoder());
            result.add(value);
            if (buf.isReadable()) {
                Object oldValue = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapValueDecoder());
                result.add(oldValue);
            }
            return result;
        }
    };

    public MapCacheEventCodec(Codec codec, BaseEventCodec.OSType osType) {
        super(codec, osType);
    }

    public MapCacheEventCodec(ClassLoader classLoader, MapCacheEventCodec codec) {
        super(MapCacheEventCodec.newCodec(classLoader, codec), codec.osType);
    }

    private static Codec newCodec(ClassLoader classLoader, MapCacheEventCodec codec) {
        try {
            return (Codec)codec.codec.getClass().getConstructor(ClassLoader.class, codec.codec.getClass()).newInstance(classLoader, codec.codec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }
}

