/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.api.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetManagementService;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageReader;

public class OffsetStorageReaderImpl
implements OffsetStorageReader {
    private OffsetManagementService offsetManagementService;

    public OffsetStorageReaderImpl(OffsetManagementService offsetManagementService) {
        this.offsetManagementService = offsetManagementService;
    }

    @Override
    public RecordOffset readOffset(RecordPartition partition) {
        return this.offsetManagementService.getPositionMap().get(partition);
    }

    @Override
    public Map<RecordPartition, RecordOffset> readOffsets(Collection<RecordPartition> partitions) {
        HashMap<RecordPartition, RecordOffset> result = new HashMap<RecordPartition, RecordOffset>();
        Map<RecordPartition, RecordOffset> allData = this.offsetManagementService.getPositionMap();
        for (RecordPartition key : partitions) {
            if (!allData.containsKey(key)) continue;
            result.put(key, allData.get(key));
        }
        return result;
    }
}

