/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage.resolver.tcp;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class TcpMessageProtocolResolver {
    public static CloudEvent buildEvent(Header header, EventMeshMessage message) throws ProtocolHandleException {
        String protocolType = header.getProperty("protocoltype").toString();
        String protocolVersion = header.getProperty("protocolversion").toString();
        String protocolDesc = header.getProperty("protocoldesc").toString();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{protocolType, protocolVersion, protocolDesc})) {
            throw new ProtocolHandleException(String.format("invalid protocol params protocolType %s|protocolVersion %s|protocolDesc %s", protocolType, protocolVersion, protocolDesc));
        }
        if (!StringUtils.equals((CharSequence)"eventmeshmessage", (CharSequence)protocolType)) {
            throw new ProtocolHandleException(String.format("Unsupported protocolType: %s", protocolType));
        }
        String topic = message.getTopic();
        String content = message.getBody();
        if (!StringUtils.equalsAny((CharSequence)protocolVersion, (CharSequence[])new CharSequence[]{SpecVersion.V1.toString(), SpecVersion.V03.toString()})) {
            throw new ProtocolHandleException(String.format("Unsupported protocolVersion: %s", protocolVersion));
        }
        CloudEventBuilder cloudEventBuilder = CloudEventBuilder.fromSpecVersion((SpecVersion)SpecVersion.parse((String)protocolVersion));
        cloudEventBuilder.withId(header.getSeq()).withSource(URI.create("/")).withType("eventmeshmessage").withSubject(topic).withData(content.getBytes(Constants.DEFAULT_CHARSET));
        if (message.getHeaders().containsKey("datacontenttype")) {
            cloudEventBuilder.withDataContentType((String)message.getHeaders().get("datacontenttype"));
        }
        for (Map.Entry prop : header.getProperties().entrySet()) {
            try {
                cloudEventBuilder.withExtension((String)prop.getKey(), prop.getValue().toString());
            }
            catch (Exception e) {
                throw new ProtocolHandleException(String.format("Abnormal propKey: %s", prop.getKey()), (Throwable)e);
            }
        }
        for (Map.Entry prop : message.getProperties().entrySet()) {
            try {
                cloudEventBuilder.withExtension((String)prop.getKey(), (String)prop.getValue());
            }
            catch (Exception e) {
                throw new ProtocolHandleException(String.format("Abnormal propKey: %s", prop.getKey()), (Throwable)e);
            }
        }
        return cloudEventBuilder.build();
    }

    public static Package buildEventMeshMessage(CloudEvent cloudEvent) {
        EventMeshMessage eventMeshMessage = new EventMeshMessage();
        eventMeshMessage.setTopic(cloudEvent.getSubject());
        eventMeshMessage.setBody(new String(Objects.requireNonNull(cloudEvent.getData()).toBytes(), Constants.DEFAULT_CHARSET));
        HashMap prop = new HashMap();
        cloudEvent.getExtensionNames().forEach(k -> prop.put(k, Objects.requireNonNull(cloudEvent.getExtension(k)).toString()));
        eventMeshMessage.setProperties(prop);
        Package pkg = new Package();
        pkg.setBody((Object)eventMeshMessage);
        if (!StringUtils.isBlank((CharSequence)cloudEvent.getDataContentType())) {
            eventMeshMessage.getHeaders().put("datacontenttype", cloudEvent.getDataContentType());
        }
        return pkg;
    }
}

