/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.concurrent.executor;

import java.util.AbstractCollection;
import java.util.Iterator;

class UnsafeArrayCollection<E>
extends AbstractCollection<E> {
    private int size = 0;
    private final Object[] array;

    public UnsafeArrayCollection(int maxSize) {
        this.array = new Object[maxSize];
    }

    @Override
    public boolean add(E o) {
        if (this.array.length < this.size) {
            throw new IndexOutOfBoundsException("size:" + this.size + " array.length:" + this.array.length);
        }
        this.array[this.size] = o;
        ++this.size;
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return this.array;
    }
}

