/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.regex.Pattern;

public class JavaTimeInstantFactory
implements JsonDeserializer<Instant>,
JsonSerializer<Instant> {
    private boolean failOnUnknownProperties;
    private Pattern NUMBER_FORMAT = Pattern.compile("-?\\d+(\\.\\d+)?");

    public JavaTimeInstantFactory() {
        this(false);
    }

    public JavaTimeInstantFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (!this.NUMBER_FORMAT.matcher(json.getAsString()).matches()) {
            if (this.failOnUnknownProperties) {
                throw new JsonParseException("Unknown instant value data: " + json.getAsString());
            }
            return null;
        }
        return Instant.ofEpochMilli(json.getAsLong());
    }

    public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src.toEpochMilli());
    }
}

