/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;

public class ResetCursorData {
    protected long ledgerId;
    protected long entryId;
    protected int partitionIndex = -1;
    protected boolean isExcluded = false;
    protected int batchIndex = -1;
    protected Map<String, String> properties;

    public ResetCursorData(long ledgerId, long entryId) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
    }

    public ResetCursorData(long ledgerId, long entryId, boolean isExcluded) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.isExcluded = isExcluded;
    }

    public ResetCursorData(long ledgerId, long entryId, boolean isExcluded, Map<String, String> properties) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.isExcluded = isExcluded;
        this.properties = properties;
    }

    private ResetCursorData(String position) {
        if ("latest".equals(position)) {
            this.ledgerId = Long.MAX_VALUE;
            this.entryId = Long.MAX_VALUE;
        } else if ("earliest".equals(position)) {
            this.ledgerId = -1L;
            this.entryId = -1L;
        } else {
            throw new IllegalArgumentException(String.format("Invalid value %s for the position. Allowed values are [latest, earliest]", position));
        }
    }

    public ResetCursorData(MessageId messageId) {
        if (messageId instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)messageId;
            this.ledgerId = batchMessageId.getLedgerId();
            this.entryId = batchMessageId.getEntryId();
            this.batchIndex = batchMessageId.getBatchIndex();
            this.partitionIndex = batchMessageId.partitionIndex;
        } else if (messageId instanceof MessageIdImpl) {
            MessageIdImpl messageIdImpl = (MessageIdImpl)messageId;
            this.ledgerId = messageIdImpl.getLedgerId();
            this.entryId = messageIdImpl.getEntryId();
            this.partitionIndex = messageIdImpl.partitionIndex;
        } else if (messageId instanceof TopicMessageIdImpl) {
            throw new IllegalArgumentException("Not supported operation on partitioned-topic");
        }
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setLedgerId(long ledgerId) {
        this.ledgerId = ledgerId;
    }

    public void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    public void setPartitionIndex(int partitionIndex) {
        this.partitionIndex = partitionIndex;
    }

    public void setExcluded(boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    public void setBatchIndex(int batchIndex) {
        this.batchIndex = batchIndex;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResetCursorData)) {
            return false;
        }
        ResetCursorData other = (ResetCursorData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLedgerId() != other.getLedgerId()) {
            return false;
        }
        if (this.getEntryId() != other.getEntryId()) {
            return false;
        }
        if (this.getPartitionIndex() != other.getPartitionIndex()) {
            return false;
        }
        if (this.isExcluded() != other.isExcluded()) {
            return false;
        }
        if (this.getBatchIndex() != other.getBatchIndex()) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResetCursorData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ledgerId = this.getLedgerId();
        result = result * 59 + (int)($ledgerId >>> 32 ^ $ledgerId);
        long $entryId = this.getEntryId();
        result = result * 59 + (int)($entryId >>> 32 ^ $entryId);
        result = result * 59 + this.getPartitionIndex();
        result = result * 59 + (this.isExcluded() ? 79 : 97);
        result = result * 59 + this.getBatchIndex();
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ResetCursorData(ledgerId=" + this.getLedgerId() + ", entryId=" + this.getEntryId() + ", partitionIndex=" + this.getPartitionIndex() + ", isExcluded=" + this.isExcluded() + ", batchIndex=" + this.getBatchIndex() + ", properties=" + this.getProperties() + ")";
    }

    public ResetCursorData() {
    }
}

