/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

@NotThreadSafe
public class MessagesImpl<T>
implements Messages<T> {
    private final List<Message<T>> messageList;
    private final int maxNumberOfMessages;
    private final long maxSizeOfMessages;
    private int currentNumberOfMessages;
    private long currentSizeOfMessages;

    protected MessagesImpl(int maxNumberOfMessages, long maxSizeOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
        this.maxSizeOfMessages = maxSizeOfMessages;
        this.messageList = maxNumberOfMessages > 0 ? new ArrayList<Message<T>>(maxNumberOfMessages) : new ArrayList();
    }

    protected boolean canAdd(Message<T> message) {
        if (this.currentNumberOfMessages == 0) {
            return true;
        }
        if (this.maxNumberOfMessages > 0 && this.currentNumberOfMessages + 1 > this.maxNumberOfMessages) {
            return false;
        }
        return this.maxSizeOfMessages <= 0L || this.currentSizeOfMessages + (long)message.size() <= this.maxSizeOfMessages;
    }

    protected void add(Message<T> message) {
        if (message == null) {
            return;
        }
        Preconditions.checkArgument(this.canAdd(message), "No more space to add messages.");
        ++this.currentNumberOfMessages;
        this.currentSizeOfMessages += (long)message.size();
        this.messageList.add(message);
    }

    public int size() {
        return this.messageList.size();
    }

    public void clear() {
        this.currentNumberOfMessages = 0;
        this.currentSizeOfMessages = 0L;
        this.messageList.clear();
    }

    List<Message<T>> getMessageList() {
        return this.messageList;
    }

    public Iterator<Message<T>> iterator() {
        return this.messageList.iterator();
    }
}

