/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.admin.handler;

import com.alibaba.otter.canal.admin.CanalAdmin;
import com.alibaba.otter.canal.admin.handler.HandshakeInitializationHandler;
import com.alibaba.otter.canal.admin.handler.SessionHandler;
import com.alibaba.otter.canal.admin.netty.AdminNettyUtils;
import com.alibaba.otter.canal.protocol.AdminPacket;
import com.alibaba.otter.canal.server.netty.NettyUtils;
import com.google.protobuf.ByteString;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class ClientAuthenticationHandler
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClientAuthenticationHandler.class);
    private final int SUPPORTED_VERSION = 3;
    private final int defaultSubscriptorDisconnectIdleTimeout = 3600000;
    private CanalAdmin canalAdmin;
    private byte[] seed;

    public ClientAuthenticationHandler() {
    }

    public ClientAuthenticationHandler(CanalAdmin canalAdmin) {
        this.canalAdmin = canalAdmin;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        byte[] errorBytes;
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        AdminPacket.Packet packet = AdminPacket.Packet.parseFrom((byte[])buffer.readBytes(buffer.readableBytes()).array());
        switch (packet.getVersion()) {
            default: 
        }
        AdminPacket.ClientAuth clientAuth = AdminPacket.ClientAuth.parseFrom((ByteString)packet.getBody());
        if (this.seed == null) {
            errorBytes = AdminNettyUtils.errorPacket(300, MessageFormatter.format((String)"auth failed for seed is null", (Object)clientAuth.getUsername()).getMessage());
            AdminNettyUtils.write(ctx.getChannel(), errorBytes);
        }
        if (!this.canalAdmin.auth(clientAuth.getUsername(), clientAuth.getPassword().toStringUtf8(), this.seed)) {
            errorBytes = AdminNettyUtils.errorPacket(300, MessageFormatter.format((String)"auth failed for user:{}", (Object)clientAuth.getUsername()).getMessage());
            AdminNettyUtils.write(ctx.getChannel(), errorBytes);
        }
        byte[] ackBytes = AdminNettyUtils.ackPacket();
        AdminNettyUtils.write(ctx.getChannel(), ackBytes, future -> {
            logger.info("remove unused channel handlers after authentication is done successfully.");
            ctx.getPipeline().remove(HandshakeInitializationHandler.class.getName());
            ctx.getPipeline().remove(ClientAuthenticationHandler.class.getName());
            int readTimeout = 3600000;
            int writeTimeout = 3600000;
            if (clientAuth.getNetReadTimeout() > 0) {
                readTimeout = clientAuth.getNetReadTimeout();
            }
            if (clientAuth.getNetWriteTimeout() > 0) {
                writeTimeout = clientAuth.getNetWriteTimeout();
            }
            IdleStateHandler idleStateHandler = new IdleStateHandler(NettyUtils.hashedWheelTimer, (long)readTimeout, (long)writeTimeout, 0L, TimeUnit.MILLISECONDS);
            ctx.getPipeline().addBefore(SessionHandler.class.getName(), IdleStateHandler.class.getName(), (ChannelHandler)idleStateHandler);
            IdleStateAwareChannelHandler idleStateAwareChannelHandler = new IdleStateAwareChannelHandler(){

                public void channelIdle(ChannelHandlerContext ctx1, IdleStateEvent e1) throws Exception {
                    logger.warn("channel:{} idle timeout exceeds, close channel to save server resources...", (Object)ctx1.getChannel());
                    ctx1.getChannel().close();
                }
            };
            ctx.getPipeline().addBefore(SessionHandler.class.getName(), IdleStateAwareChannelHandler.class.getName(), (ChannelHandler)idleStateAwareChannelHandler);
        });
    }

    public void setCanalAdmin(CanalAdmin canalAdmin) {
        this.canalAdmin = canalAdmin;
    }

    public void setSeed(byte[] seed) {
        this.seed = seed;
    }
}

