/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLUnionQueryTableSource
extends SQLTableSourceImpl {
    private SQLUnionQuery union;
    protected List<SQLName> columns = new ArrayList<SQLName>();

    public SQLUnionQueryTableSource() {
    }

    public SQLUnionQueryTableSource(String alias) {
        super(alias);
    }

    public SQLUnionQueryTableSource(SQLUnionQuery union, String alias) {
        super(alias);
        this.setUnion(union);
    }

    public SQLUnionQueryTableSource(SQLUnionQuery union) {
        this.setUnion(union);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this) && this.union != null) {
            this.union.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuilder buf) {
        buf.append("(");
        this.union.output(buf);
        buf.append(")");
    }

    public SQLUnionQuery getUnion() {
        return this.union;
    }

    public void setUnion(SQLUnionQuery union) {
        if (union != null) {
            union.setParent(this);
        }
        this.union = union;
    }

    @Override
    public SQLUnionQueryTableSource clone() {
        SQLUnionQueryTableSource x = new SQLUnionQueryTableSource(this.union.clone(), this.alias);
        if (this.flashback != null) {
            x.setFlashback(this.flashback.clone());
        }
        if (this.hints != null) {
            for (SQLHint e : this.hints) {
                SQLHint e2 = e.clone();
                e2.setParent(x);
                x.getHints().add(e2);
            }
        }
        return x;
    }

    public List<SQLName> getColumns() {
        return this.columns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SQLUnionQueryTableSource that = (SQLUnionQueryTableSource)o;
        if (this.union != null ? !this.union.equals(that.union) : that.union != null) {
            return false;
        }
        return this.columns != null ? this.columns.equals(that.columns) : that.columns == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.union != null ? this.union.hashCode() : 0);
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        return result;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
        SQLSelectItem selectItem;
        if (this.union == null) {
            return null;
        }
        SQLSelectQueryBlock firstQueryBlock = this.union.getFirstQueryBlock();
        if (firstQueryBlock != null && (selectItem = firstQueryBlock.findSelectItem(columnNameHash)) != null) {
            return this;
        }
        return null;
    }
}

