/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import io.pravega.client.segment.impl.SegmentOutputStream;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.TxnFailedException;
import io.pravega.client.stream.impl.PendingEvent;
import io.pravega.client.stream.impl.SegmentTransaction;
import io.pravega.common.concurrent.Futures;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

final class SegmentTransactionImpl<Type>
implements SegmentTransaction<Type> {
    private final Serializer<Type> serializer;
    private final UUID txId;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final SegmentOutputStream out;
    @GuardedBy(value="lock")
    private final LinkedList<CompletableFuture<Void>> outstanding = new LinkedList();
    private final AtomicReference<Throwable> txnFailedCause = new AtomicReference();

    SegmentTransactionImpl(UUID txId, SegmentOutputStream out, Serializer<Type> serializer) {
        this.txId = txId;
        this.out = out;
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEvent(Type event) throws TxnFailedException {
        this.checkFailed();
        ByteBuffer buffer = this.serializer.serialize(event);
        CompletableFuture<Void> ack = new CompletableFuture<Void>();
        PendingEvent pendingEvent = PendingEvent.withHeader(null, buffer, ack);
        Object object = this.lock;
        synchronized (object) {
            this.out.write(pendingEvent);
            this.outstanding.addLast(ack);
            this.removeCompleted();
        }
        this.checkFailed();
    }

    private void checkFailed() throws TxnFailedException {
        Throwable cause = this.txnFailedCause.get();
        if (cause != null) {
            throw new TxnFailedException(cause);
        }
    }

    @GuardedBy(value="lock")
    private void removeCompleted() {
        CompletableFuture ack;
        Iterator iter = this.outstanding.iterator();
        while (iter.hasNext() && (ack = (CompletableFuture)iter.next()).isDone()) {
            Throwable exception = Futures.getException((CompletableFuture)ack);
            if (exception != null) {
                this.txnFailedCause.compareAndSet(null, exception);
            }
            iter.remove();
        }
    }

    @Override
    public UUID getId() {
        return this.txId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws TxnFailedException {
        this.checkFailed();
        try {
            this.out.flush();
            Object object = this.lock;
            synchronized (object) {
                this.removeCompleted();
                this.checkFailed();
            }
        }
        catch (SegmentSealedException e) {
            throw new TxnFailedException(e);
        }
    }

    @Override
    public void close() throws TxnFailedException {
        this.flush();
        try {
            this.out.close();
        }
        catch (SegmentSealedException e) {
            throw new TxnFailedException(e);
        }
    }
}

