/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.format.EventSerializationException;
import io.cloudevents.protobuf.ProtoDeserializer;
import io.cloudevents.protobuf.ProtoSerializer;
import io.cloudevents.rw.CloudEventDataMapper;

public class ProtobufFormat
implements EventFormat {
    public static final String PROTO_CONTENT_TYPE = "application/cloudevents+protobuf";
    public static final String PROTO_DATA_CONTENT_TYPE = "application/protobuf";

    public byte[] serialize(CloudEvent event) throws EventSerializationException {
        try {
            io.cloudevents.v1.proto.CloudEvent asProto = ProtoSerializer.toProto(event);
            return asProto.toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            throw new EventSerializationException((Throwable)e);
        }
    }

    public CloudEvent deserialize(byte[] bytes, CloudEventDataMapper<? extends CloudEventData> mapper) throws EventDeserializationException {
        try {
            io.cloudevents.v1.proto.CloudEvent ceProto = io.cloudevents.v1.proto.CloudEvent.parseFrom(bytes);
            return (CloudEvent)new ProtoDeserializer(ceProto).read(CloudEventBuilder::fromSpecVersion);
        }
        catch (InvalidProtocolBufferException e) {
            throw new EventDeserializationException((Throwable)e);
        }
    }

    public String serializedContentType() {
        return PROTO_CONTENT_TYPE;
    }
}

