/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace
public class RemoteUnSubscribeEventProcessor
extends AbstractEventProcessor {
    private static final Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private static final Logger aclLogger = LoggerFactory.getLogger((String)"acl");

    public RemoteUnSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
    }

    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        String localAddress = IPUtils.getLocalAddress();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", remoteAddr, localAddress});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        userRequestHeaderMap.put(ProtocolKey.ClientInstanceKey.IP.getKey(), remoteAddr);
        requestWrapper.buildSysHeaderForClient();
        Map<String, Object> responseHeaderMap = this.builderResponseHeaderMap(requestWrapper);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        if (this.validateSysHeader(sysHeaderMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = Optional.ofNullable((HashMap)JsonUtils.parseTypeReferenceObject((String)new String(requestBody, Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<HashMap<String, Object>>(){})).orElseGet(Maps::newHashMap);
        if (this.validatedRequestBodyMap(requestBodyMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        String topic = JsonUtils.toJSONString((Object)requestBodyMap.get("topic").toString());
        long startTime = System.currentTimeMillis();
        try {
            List<SubscriptionItem> subscriptionList;
            String meshAddress;
            EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
            String env = eventMeshHttpConfiguration.getEventMeshEnv();
            String idc = eventMeshHttpConfiguration.getEventMeshIDC();
            String cluster = eventMeshHttpConfiguration.getEventMeshCluster();
            String sysId = eventMeshHttpConfiguration.getSysID();
            String meshGroup = String.join((CharSequence)"-", env, idc, cluster, sysId);
            String unsubscribeUrl = "http://" + localAddress + ":" + eventMeshHttpConfiguration.getHttpServerPort() + RequestURI.PUBLISH_BRIDGE.getRequestURI();
            HashMap<String, Object> remoteBodyMap = new HashMap<String, Object>();
            remoteBodyMap.put("url", unsubscribeUrl);
            remoteBodyMap.put("consumerGroup", meshGroup);
            remoteBodyMap.put("topic", requestBodyMap.get("topic"));
            List unSubTopicList = Optional.ofNullable((List)JsonUtils.parseTypeReferenceObject((String)JsonUtils.toJSONString(requestBodyMap.get("topic")), (TypeReference)new TypeReference<List<String>>(){})).orElseGet(Collections::emptyList);
            String targetMesh = "";
            if (!Objects.isNull(requestBodyMap.get("remoteMesh"))) {
                targetMesh = requestBodyMap.get("remoteMesh").toString();
            }
            if (StringUtils.isNotBlank((CharSequence)(meshAddress = this.getTargetMesh(meshGroup, subscriptionList = unSubTopicList.stream().map(s -> {
                SubscriptionItem subscriptionItem = new SubscriptionItem();
                subscriptionItem.setTopic(s);
                return subscriptionItem;
            }).collect(Collectors.toList()))))) {
                targetMesh = meshAddress;
            }
            CloseableHttpClient closeableHttpClient = this.eventMeshHTTPServer.getHttpClientPool().getClient();
            String remoteResult = RemoteUnSubscribeEventProcessor.post(closeableHttpClient, targetMesh, this.builderRemoteHeaderMap(localAddress), remoteBodyMap, (ResponseHandler<String>)((ResponseHandler)response -> EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_CHARSET)));
            Map remoteResultMap = Optional.ofNullable((Map)JsonUtils.parseTypeReferenceObject((String)remoteResult, (TypeReference)new TypeReference<Map<String, String>>(){})).orElseGet(Maps::newHashMap);
            if (String.valueOf(EventMeshRetCode.SUCCESS.getRetCode()).equals(remoteResultMap.get("retCode"))) {
                responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg());
                handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
            } else {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
            }
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}", new Object[]{endTime - startTime, topic, e});
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.UNSUBSCRIBE_REMOTE.getRequestURI()};
    }

    @Override
    public Executor executor() {
        return this.eventMeshHTTPServer.getHttpThreadPoolGroup().getClientManageExecutor();
    }
}

