/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public class LogDirCleaner {
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    private final Path logPath;
    private final int maxSize;

    public LogDirCleaner(Path logPath, int maxSize) {
        this.logPath = Objects.requireNonNull(logPath, "logPath");
        this.maxSize = maxSize;
    }

    public void clean() {
        File file = this.logPath.toFile();
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            this.logger.warn(this.logPath + " is not directory");
            return;
        }
        File[] agentDirectories = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (agentDirectories == null) {
            return;
        }
        if (agentDirectories.length > this.maxSize) {
            this.delete(agentDirectories);
        }
    }

    private void delete(File[] agentDirectories) {
        File[] deleteTargets;
        Arrays.sort(agentDirectories, Comparator.comparingLong(File::lastModified));
        int removeSize = agentDirectories.length - this.maxSize;
        for (File file : deleteTargets = Arrays.copyOfRange(agentDirectories, 0, removeSize)) {
            this.logger.info("delete agent dir:" + file.getAbsolutePath());
            this.deleteAll(file);
        }
    }

    private void deleteAll(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File curFile : files) {
                this.deleteAll(curFile);
            }
        }
        if (!file.delete()) {
            this.logger.info("delete error :" + file.getPath());
        }
    }
}

