/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.config.ConfigInfo;
import org.apache.eventmesh.common.config.convert.Convert;
import org.yaml.snakeyaml.Yaml;

public interface FileLoad {
    public static final PropertiesFileLoad PROPERTIES_FILE_LOAD = new PropertiesFileLoad();
    public static final YamlFileLoad YAML_FILE_LOAD = new YamlFileLoad();

    public static FileLoad getFileLoad(String fileType) {
        if (StringUtils.equals((CharSequence)"properties", (CharSequence)fileType)) {
            return PROPERTIES_FILE_LOAD;
        }
        if (StringUtils.equals((CharSequence)"yaml", (CharSequence)fileType)) {
            return YAML_FILE_LOAD;
        }
        return PROPERTIES_FILE_LOAD;
    }

    public static PropertiesFileLoad getPropertiesFileLoad() {
        return PROPERTIES_FILE_LOAD;
    }

    public static YamlFileLoad getYamlFileLoad() {
        return YAML_FILE_LOAD;
    }

    public <T> T getConfig(ConfigInfo var1) throws IOException;

    public static class YamlFileLoad
    implements FileLoad {
        @Override
        public <T> T getConfig(ConfigInfo configInfo) throws IOException {
            Yaml yaml = new Yaml();
            try (InputStream input = Files.newInputStream(Paths.get(configInfo.getFilePath(), new String[0]), new OpenOption[0]);){
                Object object;
                try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                    object = yaml.loadAs((Reader)reader, configInfo.getClazz());
                }
                return (T)object;
            }
        }
    }

    public static class PropertiesFileLoad
    implements FileLoad {
        private final Convert convert = new Convert();

        @Override
        public <T> T getConfig(ConfigInfo configInfo) throws IOException {
            Properties properties = new Properties();
            if (StringUtils.isNotBlank((CharSequence)configInfo.getResourceUrl())) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(configInfo.getResourceUrl())), Constants.DEFAULT_CHARSET));){
                    properties.load(reader);
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(configInfo.getFilePath(), new String[0]), new OpenOption[0]), Constants.DEFAULT_CHARSET));){
                properties.load(reader);
            }
            if (Objects.isNull(configInfo.getClazz())) {
                return (T)properties;
            }
            return (T)this.convert.doConvert(configInfo, properties);
        }

        public <T> T getConfig(Properties properties, ConfigInfo configInfo) {
            return (T)this.convert.doConvert(configInfo, properties);
        }
    }
}

