/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source;

import com.google.common.base.Preconditions;
import java.util.Objects;
import lombok.Generated;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialectFactory;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.CdcEngineFactory;
import org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.SnapshotEngineFactory;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;

public final class JdbcAllFactoryLoader {
    public static CdcEngineFactory getCdcEngineFactory(String databaseName) {
        Preconditions.checkNotNull((Object)databaseName, (Object)"database name can not be null");
        CdcEngineFactory engineFactory = (CdcEngineFactory)EventMeshExtensionFactory.getExtension(CdcEngineFactory.class, (String)databaseName);
        return (CdcEngineFactory)Preconditions.checkNotNull((Object)engineFactory, (Object)("CdcEngineFactory: " + databaseName + " is not supported"));
    }

    public static DatabaseDialectFactory getDatabaseDialectFactory(String databaseName) {
        Objects.requireNonNull(databaseName, "database name can not be null");
        DatabaseDialectFactory databaseDialectFactory = (DatabaseDialectFactory)EventMeshExtensionFactory.getExtension(DatabaseDialectFactory.class, (String)databaseName);
        Objects.requireNonNull(databaseDialectFactory, "DatabaseDialectFactory: " + databaseName + " is not supported");
        return databaseDialectFactory;
    }

    public static SnapshotEngineFactory getSnapshotEngineFactory(String databaseName) {
        Objects.requireNonNull(databaseName, "database name can not be null");
        SnapshotEngineFactory databaseDialectFactory = (SnapshotEngineFactory)EventMeshExtensionFactory.getExtension(SnapshotEngineFactory.class, (String)databaseName);
        Objects.requireNonNull(databaseDialectFactory, "SnapshotEngineFactory: " + databaseName + " is not supported");
        return databaseDialectFactory;
    }

    @Generated
    private JdbcAllFactoryLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

