/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.sink.mysql;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.eventmesh.connector.jdbc.Field;
import org.apache.eventmesh.connector.jdbc.Schema;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.dialect.SqlStatementAssembler;
import org.apache.eventmesh.connector.jdbc.sink.handle.GeneralDialectAssemblyLine;
import org.apache.eventmesh.connector.jdbc.source.SourceMateData;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.utils.JdbcStringUtils;
import org.hibernate.dialect.Dialect;

public class MysqlDialectAssemblyLine
extends GeneralDialectAssemblyLine {
    public MysqlDialectAssemblyLine(DatabaseDialect<?> databaseDialect, Dialect hibernateDialect) {
        super(databaseDialect, hibernateDialect);
    }

    @Override
    public String getUpsertStatement(SourceMateData sourceMateData, Schema schema, String originStatement) {
        SqlStatementAssembler sqlStatementAssembler = new SqlStatementAssembler();
        sqlStatementAssembler.appendSqlSlice(this.getInsertStatement(sourceMateData, schema, originStatement));
        Field afterField = schema.getFields().get(0);
        List<Column<?>> columns = afterField.getFields().stream().map(item -> item.getColumn()).sorted(Comparator.comparingInt(Column::getOrder)).collect(Collectors.toList());
        if (JdbcStringUtils.compareVersion(this.getDatabaseDialect().getJdbcDriverMetaData().getDatabaseProductVersion(), "8.0.20") >= 0) {
            sqlStatementAssembler.appendSqlSlice("AS new ON DUPLICATE KEY UPDATE ");
            sqlStatementAssembler.appendSqlSliceOfColumns(",", columns, column -> {
                String columnName = column.getName();
                return columnName + "=new." + columnName;
            });
        } else {
            sqlStatementAssembler.appendSqlSlice(" ON DUPLICATE KEY UPDATE ");
            sqlStatementAssembler.appendSqlSliceOfColumns(",", columns, column -> {
                String columnName = column.getName();
                return columnName + "=VALUES(" + columnName + ")";
            });
        }
        return sqlStatementAssembler.build();
    }
}

