/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.sink.hibernate;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;

public class DruidConnectionProvider
implements ConnectionProvider,
Configurable {
    private DruidDataSource dataSource = new DruidDataSource();

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public void configure(Map configurationValues) {
        try {
            DruidDataSourceFactory.config((DruidDataSource)this.dataSource, (Map)configurationValues);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Config druid error", e);
        }
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return this.dataSource.isWrapperFor(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.dataSource.unwrap(unwrapType);
    }
}

