/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.source.connector;

import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSourceConfig;
import org.apache.eventmesh.common.remote.job.JobType;
import org.apache.eventmesh.connector.canal.source.connector.CanalSourceCheckConnector;
import org.apache.eventmesh.connector.canal.source.connector.CanalSourceFullConnector;
import org.apache.eventmesh.connector.canal.source.connector.CanalSourceIncrementConnector;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalSourceConnector
implements Source,
ConnectorCreateService<Source> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalSourceConnector.class);
    private CanalSourceConfig sourceConfig;
    private Source source;

    public Class<? extends Config> configClass() {
        return CanalSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (CanalSourceConfig)config;
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        if (sourceConnectorContext.getJobType().equals((Object)JobType.FULL)) {
            this.source = new CanalSourceFullConnector();
        } else if (sourceConnectorContext.getJobType().equals((Object)JobType.INCREASE)) {
            this.source = new CanalSourceIncrementConnector();
        } else if (sourceConnectorContext.getJobType().equals((Object)JobType.CHECK)) {
            this.source = new CanalSourceCheckConnector();
        } else {
            throw new RuntimeException("unsupported job type " + sourceConnectorContext.getJobType());
        }
        this.source.init((ConnectorContext)sourceConnectorContext);
    }

    public void start() throws Exception {
        this.source.start();
    }

    public void commit(ConnectRecord record) {
        this.source.commit(record);
    }

    public String name() {
        return this.source.name();
    }

    public void onException(ConnectRecord record) {
        this.source.onException(record);
    }

    public void stop() throws Exception {
        this.source.stop();
    }

    public List<ConnectRecord> poll() {
        return this.source.poll();
    }

    public Source create() {
        return new CanalSourceConnector();
    }
}

