/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.sink.connector;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.JdbcConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSinkConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSinkFullConfig;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.canal.DatabaseConnection;
import org.apache.eventmesh.connector.canal.sink.connector.CanalCheckConsumer;
import org.apache.eventmesh.connector.canal.source.table.RdbTableMgr;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalSinkCheckConnector
implements Sink,
ConnectorCreateService<Sink> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalSinkCheckConnector.class);
    private CanalSinkFullConfig config;
    private RdbTableMgr tableMgr;
    private ThreadPoolExecutor executor;
    private final BlockingQueue<List<ConnectRecord>> queue = new LinkedBlockingQueue<List<ConnectRecord>>(10000);
    private final AtomicBoolean flag = new AtomicBoolean(true);

    public void start() throws Exception {
        this.tableMgr.start();
    }

    public void stop() throws Exception {
        this.flag.set(false);
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warn("wait thread pool shutdown timeout, it will shutdown now");
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("shutdown thread pool fail");
            }
        }
        if (DatabaseConnection.sinkDataSource != null) {
            DatabaseConnection.sinkDataSource.close();
            log.info("data source has been closed");
        }
    }

    public Sink create() {
        return new CanalSinkCheckConnector();
    }

    public Class<? extends Config> configClass() {
        return CanalSinkFullConfig.class;
    }

    public void init(Config config) throws Exception {
        this.config = (CanalSinkFullConfig)config;
        this.init();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        CanalSinkConfig canalSinkConfig = (CanalSinkConfig)((SinkConnectorContext)connectorContext).getSinkConfig();
        this.config = (CanalSinkFullConfig)ConfigUtil.parse((Map)canalSinkConfig.getSinkConfig(), CanalSinkFullConfig.class);
        this.init();
    }

    private void init() {
        if (this.config.getSinkConnectorConfig() == null) {
            throw new EventMeshException(String.format("[%s] sink config is null", this.getClass()));
        }
        DatabaseConnection.sinkConfig = this.config.getSinkConnectorConfig();
        DatabaseConnection.initSinkConnection();
        DatabaseConnection.sinkDataSource.setDefaultAutoCommit(false);
        this.tableMgr = new RdbTableMgr((JdbcConfig)this.config.getSinkConnectorConfig(), (DataSource)DatabaseConnection.sinkDataSource);
        this.executor = new ThreadPoolExecutor(this.config.getParallel(), this.config.getParallel(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new EventMeshThreadFactory("canal-sink-check"));
        LinkedList<CanalCheckConsumer> consumers = new LinkedList<CanalCheckConsumer>();
        for (int i = 0; i < this.config.getParallel(); ++i) {
            CanalCheckConsumer canalCheckConsumer = new CanalCheckConsumer(this.queue, this.tableMgr, this.config);
            consumers.add(canalCheckConsumer);
        }
        consumers.forEach(c -> this.executor.execute(() -> c.start(this.flag)));
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return null;
    }

    public void onException(ConnectRecord record) {
    }

    public void put(List<ConnectRecord> sinkRecords) {
        if (sinkRecords == null || sinkRecords.isEmpty() || sinkRecords.get(0) == null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] got sink records are none", this.getClass());
            }
            return;
        }
        try {
            this.queue.put(sinkRecords);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

