/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.model;

public enum EventType {
    INSERT("I"),
    UPDATE("U"),
    DELETE("D"),
    CREATE("C"),
    ALTER("A"),
    ERASE("E"),
    QUERY("Q"),
    TRUNCATE("T"),
    RENAME("R"),
    CINDEX("CI"),
    DINDEX("DI");

    private String value;

    private EventType(String value) {
        this.value = value;
    }

    public boolean isInsert() {
        return this.equals((Object)INSERT);
    }

    public boolean isUpdate() {
        return this.equals((Object)UPDATE);
    }

    public boolean isDelete() {
        return this.equals((Object)DELETE);
    }

    public boolean isCreate() {
        return this.equals((Object)CREATE);
    }

    public boolean isAlter() {
        return this.equals((Object)ALTER);
    }

    public boolean isErase() {
        return this.equals((Object)ERASE);
    }

    public boolean isQuery() {
        return this.equals((Object)QUERY);
    }

    public boolean isTruncate() {
        return this.equals((Object)TRUNCATE);
    }

    public boolean isRename() {
        return this.equals((Object)RENAME);
    }

    public boolean isCindex() {
        return this.equals((Object)CINDEX);
    }

    public boolean isDindex() {
        return this.equals((Object)DINDEX);
    }

    public boolean isDdl() {
        return this.isCreate() || this.isAlter() || this.isErase() || this.isTruncate() || this.isRename() || this.isCindex() || this.isDindex();
    }

    public boolean isDml() {
        return this.isInsert() || this.isUpdate() || this.isDelete();
    }

    public static EventType valuesOf(String value) {
        EventType[] eventTypes;
        for (EventType eventType : eventTypes = EventType.values()) {
            if (!eventType.value.equalsIgnoreCase(value)) continue;
            return eventType;
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

