/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CopyCompletionError;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.DataAccessAuthMode;
import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.DiskState;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class SnapshotProperties {
    @JsonProperty(value="timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;
    @JsonProperty(value="osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;
    @JsonProperty(value="supportedCapabilities")
    private SupportedCapabilities supportedCapabilities;
    @JsonProperty(value="creationData", required=true)
    private CreationData creationData;
    @JsonProperty(value="diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="diskSizeBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long diskSizeBytes;
    @JsonProperty(value="diskState", access=JsonProperty.Access.WRITE_ONLY)
    private DiskState diskState;
    @JsonProperty(value="uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;
    @JsonProperty(value="encryptionSettingsCollection")
    private EncryptionSettingsCollection encryptionSettingsCollection;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="incremental")
    private Boolean incremental;
    @JsonProperty(value="incrementalSnapshotFamilyId", access=JsonProperty.Access.WRITE_ONLY)
    private String incrementalSnapshotFamilyId;
    @JsonProperty(value="encryption")
    private Encryption encryption;
    @JsonProperty(value="networkAccessPolicy")
    private NetworkAccessPolicy networkAccessPolicy;
    @JsonProperty(value="diskAccessId")
    private String diskAccessId;
    @JsonProperty(value="securityProfile")
    private DiskSecurityProfile securityProfile;
    @JsonProperty(value="supportsHibernation")
    private Boolean supportsHibernation;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="completionPercent")
    private Float completionPercent;
    @JsonProperty(value="copyCompletionError")
    private CopyCompletionError copyCompletionError;
    @JsonProperty(value="dataAccessAuthMode")
    private DataAccessAuthMode dataAccessAuthMode;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotProperties.class);

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SnapshotProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public SnapshotProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public SnapshotProperties withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public SnapshotProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public SnapshotProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public SnapshotProperties withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    public DiskState diskState() {
        return this.diskState;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public SnapshotProperties withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean incremental() {
        return this.incremental;
    }

    public SnapshotProperties withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    public String incrementalSnapshotFamilyId() {
        return this.incrementalSnapshotFamilyId;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public SnapshotProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public SnapshotProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public SnapshotProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public SnapshotProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public SnapshotProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SnapshotProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Float completionPercent() {
        return this.completionPercent;
    }

    public SnapshotProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    public CopyCompletionError copyCompletionError() {
        return this.copyCompletionError;
    }

    public SnapshotProperties withCopyCompletionError(CopyCompletionError copyCompletionError) {
        this.copyCompletionError = copyCompletionError;
        return this;
    }

    public DataAccessAuthMode dataAccessAuthMode() {
        return this.dataAccessAuthMode;
    }

    public SnapshotProperties withDataAccessAuthMode(DataAccessAuthMode dataAccessAuthMode) {
        this.dataAccessAuthMode = dataAccessAuthMode;
        return this;
    }

    public void validate() {
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.supportedCapabilities() != null) {
            this.supportedCapabilities().validate();
        }
        if (this.creationData() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property creationData in model SnapshotProperties"));
        }
        this.creationData().validate();
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.copyCompletionError() != null) {
            this.copyCompletionError().validate();
        }
    }
}

