/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Transformation {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="dataset")
    private DatasetReference dataset;
    @JsonProperty(value="linkedService")
    private LinkedServiceReference linkedService;
    @JsonProperty(value="flowlet")
    private DataFlowReference flowlet;
    private static final ClientLogger LOGGER = new ClientLogger(Transformation.class);

    public String name() {
        return this.name;
    }

    public Transformation withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Transformation withDescription(String description) {
        this.description = description;
        return this;
    }

    public DatasetReference dataset() {
        return this.dataset;
    }

    public Transformation withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public LinkedServiceReference linkedService() {
        return this.linkedService;
    }

    public Transformation withLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    public DataFlowReference flowlet() {
        return this.flowlet;
    }

    public Transformation withFlowlet(DataFlowReference flowlet) {
        this.flowlet = flowlet;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Transformation"));
        }
        if (this.dataset() != null) {
            this.dataset().validate();
        }
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
        if (this.flowlet() != null) {
            this.flowlet().validate();
        }
    }
}

