/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.handler;

import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.AbstractWorkflowLifecycleLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.listener.IWorkflowLifecycleListener;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.IWorkflowStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.WorkflowStateActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWorkflowLifecycleEventHandler<T extends AbstractWorkflowLifecycleLifecycleEvent>
implements ILifecycleEventHandler<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowLifecycleEventHandler.class);
    @Autowired
    private WorkflowStateActionFactory workflowStateActionFactory;

    @Override
    public void handle(IWorkflowExecutionRunnable workflowExecutionRunnable, T event) {
        IWorkflowStateAction action = this.workflowStateActionFactory.getAction(workflowExecutionRunnable.getState());
        log.info("Begin fire workflow {} LifecycleEvent[{}] with state: {}", new Object[]{workflowExecutionRunnable.getName(), event, workflowExecutionRunnable.getState().name()});
        this.handle(action, workflowExecutionRunnable, event);
        log.info("Fired workflow {} LifecycleEvent[{}] with state: {}", new Object[]{workflowExecutionRunnable.getName(), event, workflowExecutionRunnable.getState().name()});
        this.doTriggerWorkflowLifecycleListener(workflowExecutionRunnable, event);
    }

    public abstract void handle(IWorkflowStateAction var1, IWorkflowExecutionRunnable var2, T var3);

    private void doTriggerWorkflowLifecycleListener(IWorkflowExecutionRunnable workflowExecutionRunnable, T event) {
        List<IWorkflowLifecycleListener> listeners = workflowExecutionRunnable.getWorkflowLifecycleListeners();
        if (CollectionUtils.isEmpty(listeners)) {
            return;
        }
        for (IWorkflowLifecycleListener listener : listeners) {
            try {
                if (!listener.match((AbstractWorkflowLifecycleLifecycleEvent)((Object)event))) continue;
                listener.notifyWorkflowLifecycleEvent(workflowExecutionRunnable, (AbstractWorkflowLifecycleLifecycleEvent)((Object)event));
            }
            catch (Exception e) {
                log.warn("Trigger WorkflowLifecycleListener on event: {} failed", event, (Object)e);
            }
        }
    }
}

