/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow;

import lombok.Generated;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.executor.workflow.IExecutorDelegate;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksResponse;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecoverFailureTaskInstanceExecutorDelegate
implements IExecutorDelegate<RecoverFailureTaskInstanceOperation, Void> {
    @Autowired
    private RegistryClient registryClient;

    @Override
    public Void execute(RecoverFailureTaskInstanceOperation recoverFailureTaskInstanceOperation) {
        WorkflowInstance workflowInstance = recoverFailureTaskInstanceOperation.getWorkflowInstance();
        if (!workflowInstance.getState().isFailure()) {
            throw new ServiceException(String.format("The workflow instance: %s status is %s, can not be recovered", workflowInstance.getName(), workflowInstance.getState()));
        }
        Server masterServer = this.registryClient.getRandomServer(RegistryNodeType.MASTER).orElse(null);
        if (masterServer == null) {
            throw new ServiceException("no master server available");
        }
        WorkflowInstanceRecoverFailureTasksRequest recoverFailureTaskRequest = WorkflowInstanceRecoverFailureTasksRequest.builder().workflowInstanceId(workflowInstance.getId()).userId(recoverFailureTaskInstanceOperation.executeUser.getId()).build();
        WorkflowInstanceRecoverFailureTasksResponse recoverFailureTaskResponse = ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(masterServer.getHost() + ":" + masterServer.getPort())).triggerFromFailureTasks(recoverFailureTaskRequest);
        if (!recoverFailureTaskResponse.isSuccess()) {
            throw new ServiceException("Recover workflow instance failed: " + recoverFailureTaskResponse.getMessage());
        }
        return null;
    }

    public static class RecoverFailureTaskInstanceOperation {
        private final RecoverFailureTaskInstanceExecutorDelegate recoverFailureTaskInstanceExecutorDelegate;
        private WorkflowInstance workflowInstance;
        private User executeUser;

        public RecoverFailureTaskInstanceOperation(RecoverFailureTaskInstanceExecutorDelegate recoverFailureTaskInstanceExecutorDelegate) {
            this.recoverFailureTaskInstanceExecutorDelegate = recoverFailureTaskInstanceExecutorDelegate;
        }

        public RecoverFailureTaskInstanceOperation onWorkflowInstance(WorkflowInstance workflowInstance) {
            this.workflowInstance = workflowInstance;
            return this;
        }

        public RecoverFailureTaskInstanceOperation byUser(User executeUser) {
            this.executeUser = executeUser;
            return this;
        }

        public void execute() {
            this.recoverFailureTaskInstanceExecutorDelegate.execute(this);
        }

        @Generated
        public RecoverFailureTaskInstanceExecutorDelegate getRecoverFailureTaskInstanceExecutorDelegate() {
            return this.recoverFailureTaskInstanceExecutorDelegate;
        }

        @Generated
        public WorkflowInstance getWorkflowInstance() {
            return this.workflowInstance;
        }

        @Generated
        public User getExecuteUser() {
            return this.executeUser;
        }
    }
}

