/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.core.util.Base64Url;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class KeyVerifyRequest {
    @JsonProperty(value="alg", required=true)
    private SignatureAlgorithm algorithm;
    @JsonProperty(value="digest", required=true)
    private Base64Url digest;
    @JsonProperty(value="value", required=true)
    private Base64Url signature;

    public SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public KeyVerifyRequest setAlgorithm(SignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public byte[] getDigest() {
        if (this.digest == null) {
            return new byte[0];
        }
        return this.digest.decodedBytes();
    }

    public KeyVerifyRequest setDigest(byte[] digest) {
        this.digest = digest == null ? null : Base64Url.encode((byte[])digest);
        return this;
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            return new byte[0];
        }
        return this.signature.decodedBytes();
    }

    public KeyVerifyRequest setSignature(byte[] signature) {
        this.signature = signature == null ? null : Base64Url.encode((byte[])signature);
        return this;
    }
}

