/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryThreadFactory;
import org.apache.dolphinscheduler.plugin.registry.jdbc.client.IJdbcRegistryClient;
import org.apache.dolphinscheduler.plugin.registry.jdbc.client.JdbcRegistryClientIdentify;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.DataType;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryClientHeartbeatDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryClientRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryDataChanceEventRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryDataRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryLockRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.ConnectionStateListener;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IJdbcRegistryServer;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IRegistryRowChangeNotifier;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.JdbcRegistryDataChangeListener;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.JdbcRegistryDataManager;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.JdbcRegistryLockManager;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.JdbcRegistryServerState;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRegistryServer
implements IJdbcRegistryServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistryServer.class);
    private final JdbcRegistryProperties jdbcRegistryProperties;
    private final JdbcRegistryDataRepository jdbcRegistryDataRepository;
    private final JdbcRegistryLockRepository jdbcRegistryLockRepository;
    private final JdbcRegistryClientRepository jdbcRegistryClientRepository;
    private final JdbcRegistryDataManager jdbcRegistryDataManager;
    private final JdbcRegistryLockManager jdbcRegistryLockManager;
    private JdbcRegistryServerState jdbcRegistryServerState;
    private final List<IJdbcRegistryClient> jdbcRegistryClients = new CopyOnWriteArrayList<IJdbcRegistryClient>();
    private final List<ConnectionStateListener> connectionStateListeners = new CopyOnWriteArrayList<ConnectionStateListener>();
    private final Map<JdbcRegistryClientIdentify, JdbcRegistryClientHeartbeatDTO> jdbcRegistryClientDTOMap = new ConcurrentHashMap<JdbcRegistryClientIdentify, JdbcRegistryClientHeartbeatDTO>();
    private Long lastSuccessHeartbeat;

    public JdbcRegistryServer(JdbcRegistryDataRepository jdbcRegistryDataRepository, JdbcRegistryLockRepository jdbcRegistryLockRepository, JdbcRegistryClientRepository jdbcRegistryClientRepository, JdbcRegistryDataChanceEventRepository jdbcRegistryDataChanceEventRepository, JdbcRegistryProperties jdbcRegistryProperties) {
        this.jdbcRegistryDataRepository = (JdbcRegistryDataRepository)Preconditions.checkNotNull((Object)jdbcRegistryDataRepository);
        this.jdbcRegistryLockRepository = (JdbcRegistryLockRepository)Preconditions.checkNotNull((Object)jdbcRegistryLockRepository);
        this.jdbcRegistryClientRepository = (JdbcRegistryClientRepository)Preconditions.checkNotNull((Object)jdbcRegistryClientRepository);
        this.jdbcRegistryProperties = (JdbcRegistryProperties)Preconditions.checkNotNull((Object)jdbcRegistryProperties);
        this.jdbcRegistryDataManager = new JdbcRegistryDataManager(jdbcRegistryProperties, jdbcRegistryDataRepository, jdbcRegistryDataChanceEventRepository);
        this.jdbcRegistryLockManager = new JdbcRegistryLockManager(jdbcRegistryProperties, jdbcRegistryLockRepository);
        this.jdbcRegistryServerState = JdbcRegistryServerState.INIT;
        this.lastSuccessHeartbeat = System.currentTimeMillis();
    }

    @Override
    public void start() {
        if (this.jdbcRegistryServerState != JdbcRegistryServerState.INIT) {
            return;
        }
        this.purgeInvalidJdbcRegistryMetadata();
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(this::purgeInvalidJdbcRegistryMetadata, this.jdbcRegistryProperties.getSessionTimeout().toMillis(), this.jdbcRegistryProperties.getSessionTimeout().toMillis(), TimeUnit.MILLISECONDS);
        this.jdbcRegistryDataManager.start();
        this.jdbcRegistryServerState = JdbcRegistryServerState.STARTED;
        this.doTriggerOnConnectedListener();
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(this::refreshClientsHeartbeat, 0L, this.jdbcRegistryProperties.getHeartbeatRefreshInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void registerClient(IJdbcRegistryClient jdbcRegistryClient) {
        Preconditions.checkNotNull((Object)jdbcRegistryClient);
        JdbcRegistryClientIdentify jdbcRegistryClientIdentify = jdbcRegistryClient.getJdbcRegistryClientIdentify();
        Preconditions.checkNotNull((Object)jdbcRegistryClientIdentify);
        JdbcRegistryClientHeartbeatDTO registryClientDTO = JdbcRegistryClientHeartbeatDTO.builder().id(jdbcRegistryClientIdentify.getClientId()).clientName(jdbcRegistryClientIdentify.getClientName()).clientConfig(new JdbcRegistryClientHeartbeatDTO.ClientConfig(this.jdbcRegistryProperties.getSessionTimeout().toMillis())).createTime(new Date()).lastHeartbeatTime(System.currentTimeMillis()).build();
        if (this.jdbcRegistryClientDTOMap.containsKey(jdbcRegistryClientIdentify)) {
            throw new IllegalArgumentException("The client is already registered: " + jdbcRegistryClientIdentify);
        }
        this.jdbcRegistryClientRepository.insert(registryClientDTO);
        this.jdbcRegistryClients.add(jdbcRegistryClient);
        this.jdbcRegistryClientDTOMap.put(jdbcRegistryClientIdentify, registryClientDTO);
    }

    @Override
    public void deregisterClient(IJdbcRegistryClient jdbcRegistryClient) {
        Preconditions.checkNotNull((Object)jdbcRegistryClient);
        JdbcRegistryClientIdentify clientIdentify = jdbcRegistryClient.getJdbcRegistryClientIdentify();
        Preconditions.checkNotNull((Object)clientIdentify);
        this.jdbcRegistryClients.removeIf(client -> clientIdentify.equals(client.getJdbcRegistryClientIdentify()));
        this.jdbcRegistryClientDTOMap.remove(jdbcRegistryClient.getJdbcRegistryClientIdentify());
        this.doPurgeJdbcRegistryClientInDB(Lists.newArrayList((Object[])new Long[]{clientIdentify.getClientId()}));
    }

    @Override
    public JdbcRegistryServerState getServerState() {
        return this.jdbcRegistryServerState;
    }

    @Override
    public void subscribeConnectionStateChange(ConnectionStateListener connectionStateListener) {
        Preconditions.checkNotNull((Object)connectionStateListener);
        this.connectionStateListeners.add(connectionStateListener);
    }

    @Override
    public void subscribeJdbcRegistryDataChange(final JdbcRegistryDataChangeListener jdbcRegistryDataChangeListener) {
        Preconditions.checkNotNull((Object)jdbcRegistryDataChangeListener);
        this.jdbcRegistryDataManager.subscribeRegistryRowChange(new IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO>(){

            @Override
            public void onRegistryRowUpdated(JdbcRegistryDataDTO data) {
                jdbcRegistryDataChangeListener.onJdbcRegistryDataChanged(data.getDataKey(), data.getDataValue());
            }

            @Override
            public void onRegistryRowAdded(JdbcRegistryDataDTO data) {
                jdbcRegistryDataChangeListener.onJdbcRegistryDataAdded(data.getDataKey(), data.getDataValue());
            }

            @Override
            public void onRegistryRowDeleted(JdbcRegistryDataDTO data) {
                jdbcRegistryDataChangeListener.onJdbcRegistryDataDeleted(data.getDataKey());
            }
        });
    }

    @Override
    public boolean existJdbcRegistryDataKey(String key) {
        return this.jdbcRegistryDataManager.existKey(key);
    }

    @Override
    public Optional<JdbcRegistryDataDTO> getJdbcRegistryDataByKey(String key) {
        return this.jdbcRegistryDataManager.getRegistryDataByKey(key);
    }

    @Override
    public List<JdbcRegistryDataDTO> listJdbcRegistryDataChildren(String key) {
        return this.jdbcRegistryDataManager.listJdbcRegistryDataChildren(key);
    }

    @Override
    public void putJdbcRegistryData(Long clientId, String key, String value, DataType dataType) {
        this.jdbcRegistryDataManager.putJdbcRegistryData(clientId, key, value, dataType);
    }

    @Override
    public void deleteJdbcRegistryDataByKey(String key) {
        this.jdbcRegistryDataManager.deleteJdbcRegistryDataByKey(key);
    }

    @Override
    public void acquireJdbcRegistryLock(Long clientId, String lockKey) {
        try {
            this.jdbcRegistryLockManager.acquireJdbcRegistryLock(clientId, lockKey);
        }
        catch (Exception ex) {
            throw new RegistryException("Acquire the lock: " + lockKey + " error", (Throwable)ex);
        }
    }

    @Override
    public boolean acquireJdbcRegistryLock(Long clientId, String lockKey, long timeout) {
        try {
            return this.jdbcRegistryLockManager.acquireJdbcRegistryLock(clientId, lockKey, timeout);
        }
        catch (Exception ex) {
            throw new RegistryException("Acquire the lock: " + lockKey + " error", (Throwable)ex);
        }
    }

    @Override
    public void releaseJdbcRegistryLock(Long clientId, String lockKey) {
        try {
            this.jdbcRegistryLockManager.releaseJdbcRegistryLock(clientId, lockKey);
        }
        catch (Exception ex) {
            throw new RegistryException("Release the lock: " + lockKey + " error", (Throwable)ex);
        }
    }

    @Override
    public void close() {
        this.jdbcRegistryServerState = JdbcRegistryServerState.STOPPED;
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().shutdown();
        List<Long> clientIds = this.jdbcRegistryClients.stream().map(IJdbcRegistryClient::getJdbcRegistryClientIdentify).map(JdbcRegistryClientIdentify::getClientId).collect(Collectors.toList());
        this.doPurgeJdbcRegistryClientInDB(clientIds);
        this.jdbcRegistryClients.clear();
        this.jdbcRegistryClientDTOMap.clear();
    }

    private void purgeInvalidJdbcRegistryMetadata() {
        StopWatch stopWatch = StopWatch.createStarted();
        if (this.jdbcRegistryServerState == JdbcRegistryServerState.STOPPED) {
            return;
        }
        List<JdbcRegistryClientHeartbeatDTO> jdbcRegistryClients = this.jdbcRegistryClientRepository.queryAll();
        List<Long> deadJdbcRegistryClientIds = jdbcRegistryClients.stream().filter(JdbcRegistryClientHeartbeatDTO::isDead).map(JdbcRegistryClientHeartbeatDTO::getId).collect(Collectors.toList());
        this.doPurgeJdbcRegistryClientInDB(deadJdbcRegistryClientIds);
        Set existJdbcRegistryClientIds = jdbcRegistryClients.stream().map(JdbcRegistryClientHeartbeatDTO::getId).collect(Collectors.toSet());
        this.jdbcRegistryDataManager.getAllJdbcRegistryData().stream().filter(jdbcRegistryDataDTO -> !existJdbcRegistryClientIds.contains(jdbcRegistryDataDTO.getClientId())).filter(jdbcRegistryDataDTO -> DataType.EPHEMERAL.name().equals(jdbcRegistryDataDTO.getDataType())).forEach(jdbcRegistryData -> {
            log.info("Remove the JdbcRegistryData: {} which client is not exist in the registry", jdbcRegistryData);
            this.jdbcRegistryDataManager.deleteJdbcRegistryDataByKey(jdbcRegistryData.getDataKey());
        });
        this.jdbcRegistryLockRepository.queryAll().stream().filter(jdbcRegistryLockDTO -> !existJdbcRegistryClientIds.contains(jdbcRegistryLockDTO.getClientId())).forEach(jdbcRegistryLockDTO -> {
            log.info("Remove the JdbcRegistryLock: {} which client is not exist in the registry", jdbcRegistryLockDTO);
            this.jdbcRegistryLockRepository.deleteById(jdbcRegistryLockDTO.getId());
        });
        stopWatch.stop();
        log.debug("Success purge invalid jdbcRegistryMetadata, cost: {} ms", (Object)stopWatch.getTime());
    }

    private void doPurgeJdbcRegistryClientInDB(List<Long> jdbcRegistryClientIds) {
        if (CollectionUtils.isEmpty(jdbcRegistryClientIds)) {
            return;
        }
        log.info("Begin to delete dead jdbcRegistryClient: {}", jdbcRegistryClientIds);
        this.jdbcRegistryDataRepository.deleteEphemeralDateByClientIds(jdbcRegistryClientIds);
        this.jdbcRegistryLockRepository.deleteByClientIds(jdbcRegistryClientIds);
        this.jdbcRegistryClientRepository.deleteByIds(jdbcRegistryClientIds);
        log.info("Success delete dead jdbcRegistryClient: {}", jdbcRegistryClientIds);
    }

    private void refreshClientsHeartbeat() {
        if (CollectionUtils.isEmpty(this.jdbcRegistryClients)) {
            return;
        }
        if (this.jdbcRegistryServerState == JdbcRegistryServerState.STOPPED) {
            log.warn("The JdbcRegistryServer is STOPPED, will not refresh clients: {} heartbeat.", (Object)CollectionUtils.collect(this.jdbcRegistryClients, IJdbcRegistryClient::getJdbcRegistryClientIdentify));
            return;
        }
        try {
            long now = System.currentTimeMillis();
            for (IJdbcRegistryClient jdbcRegistryClient : this.jdbcRegistryClients) {
                JdbcRegistryClientHeartbeatDTO jdbcRegistryClientHeartbeatDTO = this.jdbcRegistryClientDTOMap.get(jdbcRegistryClient.getJdbcRegistryClientIdentify());
                if (jdbcRegistryClientHeartbeatDTO == null) {
                    log.error("The client {} is not found in the registry, will not refresh it's term. (This may happen when the client is removed from the db)", (Object)jdbcRegistryClient.getJdbcRegistryClientIdentify().getClientId());
                    continue;
                }
                JdbcRegistryClientHeartbeatDTO clone = jdbcRegistryClientHeartbeatDTO.clone();
                clone.setLastHeartbeatTime(now);
                this.jdbcRegistryClientRepository.updateById(jdbcRegistryClientHeartbeatDTO);
                jdbcRegistryClientHeartbeatDTO.setLastHeartbeatTime(clone.getLastHeartbeatTime());
            }
            if (this.jdbcRegistryServerState == JdbcRegistryServerState.SUSPENDED) {
                this.jdbcRegistryServerState = JdbcRegistryServerState.STARTED;
                this.doTriggerReconnectedListener();
            }
            this.lastSuccessHeartbeat = now;
            log.debug("Success refresh clients: {} heartbeat.", (Object)CollectionUtils.collect(this.jdbcRegistryClients, IJdbcRegistryClient::getJdbcRegistryClientIdentify));
        }
        catch (Exception ex) {
            log.error("Failed to refresh the client's term", (Throwable)ex);
            switch (this.jdbcRegistryServerState) {
                case STARTED: {
                    this.jdbcRegistryServerState = JdbcRegistryServerState.SUSPENDED;
                    break;
                }
                case SUSPENDED: {
                    if (System.currentTimeMillis() - this.lastSuccessHeartbeat <= this.jdbcRegistryProperties.getSessionTimeout().toMillis()) break;
                    this.jdbcRegistryServerState = JdbcRegistryServerState.DISCONNECTED;
                    this.doTriggerOnDisConnectedListener();
                    break;
                }
            }
        }
    }

    private void doTriggerReconnectedListener() {
        log.info("Trigger:onReconnected listener.");
        this.connectionStateListeners.forEach(listener -> {
            try {
                listener.onReconnected();
            }
            catch (Exception ex) {
                log.error("Trigger:onReconnected failed", (Throwable)ex);
            }
        });
    }

    private void doTriggerOnConnectedListener() {
        log.info("Trigger:onConnected listener.");
        this.connectionStateListeners.forEach(listener -> {
            try {
                listener.onConnected();
            }
            catch (Exception ex) {
                log.error("Trigger:onConnected failed", (Throwable)ex);
            }
        });
    }

    private void doTriggerOnDisConnectedListener() {
        log.info("Trigger:onDisConnected listener.");
        this.connectionStateListeners.forEach(listener -> {
            try {
                listener.onDisConnected();
            }
            catch (Exception ex) {
                log.error("Trigger:onDisConnected failed", (Throwable)ex);
            }
        });
    }
}

