/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.implementation.Utils;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayImpl;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.VirtualNetworkGateway;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayIpConfiguration;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

class VirtualNetworkGatewayIpConfigurationImpl
extends ChildResourceImpl<VirtualNetworkGatewayIpConfigurationInner, VirtualNetworkGatewayImpl, VirtualNetworkGateway>
implements VirtualNetworkGatewayIpConfiguration,
VirtualNetworkGatewayIpConfiguration.Definition<VirtualNetworkGateway.DefinitionStages.WithCreate>,
VirtualNetworkGatewayIpConfiguration.UpdateDefinition<VirtualNetworkGateway.Update>,
VirtualNetworkGatewayIpConfiguration.Update {
    VirtualNetworkGatewayIpConfigurationImpl(VirtualNetworkGatewayIpConfigurationInner inner, VirtualNetworkGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).name();
    }

    @Override
    public String publicIpAddressId() {
        if (((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).publicIpAddress() != null) {
            return ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).publicIpAddress().id();
        }
        return null;
    }

    @Override
    public String networkId() {
        SubResource subnetRef = ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String subnetName() {
        SubResource subnetRef = ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public IpAllocationMethod privateIpAllocationMethod() {
        return ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).privateIpAllocationMethod();
    }

    @Override
    public Subnet getSubnet() {
        return Utils.getAssociatedSubnet((NetworkManager)((VirtualNetworkGatewayImpl)this.parent()).manager(), ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).subnet());
    }

    public VirtualNetworkGatewayIpConfigurationImpl withExistingSubnet(String networkId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(networkId + "/subnets/" + subnetName);
        ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).withSubnet(subnetRef);
        return this;
    }

    public VirtualNetworkGatewayIpConfigurationImpl withExistingSubnet(Subnet subnet) {
        return this.withExistingSubnet(((Network)subnet.parent()).id(), subnet.name());
    }

    public VirtualNetworkGatewayIpConfigurationImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public VirtualNetworkGatewayImpl attach() {
        return ((VirtualNetworkGatewayImpl)this.parent()).withConfig(this);
    }

    @Override
    public VirtualNetworkGatewayIpConfigurationImpl withExistingPublicIpAddress(PublicIpAddress pip) {
        return this.withExistingPublicIpAddress(pip.id());
    }

    @Override
    public VirtualNetworkGatewayIpConfigurationImpl withExistingPublicIpAddress(String resourceId) {
        SubResource pipRef = new SubResource().withId(resourceId);
        ((VirtualNetworkGatewayIpConfigurationInner)((Object)this.innerModel())).withPublicIpAddress(pipRef);
        return this;
    }
}

