/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;

class ResourceHandlerImpl<T extends HasMetadata, V extends VisitableBuilder<T, V>>
implements ResourceHandler<T, V> {
    private final ResourceDefinitionContext context;
    private final Class<T> type;
    private final Class<V> builderClass;
    private final Class<? extends KubernetesResourceList<T>> defaultListClass;
    private final Function<Client, HasMetadataOperation<T, ?, Resource<T>>> operationConstructor;

    ResourceHandlerImpl(Class<T> type, Function<Client, HasMetadataOperation<T, ?, Resource<T>>> operationConstructor) {
        this.type = type;
        this.context = ResourceDefinitionContext.fromResourceType(type);
        this.builderClass = KubernetesResourceUtil.inferBuilderType(type);
        this.defaultListClass = KubernetesResourceUtil.inferListType(type);
        this.operationConstructor = operationConstructor;
    }

    ResourceHandlerImpl(Class<T> type, Class<? extends KubernetesResourceList<T>> listClass, ResourceDefinitionContext context) {
        this.type = type;
        this.context = context;
        this.defaultListClass = listClass;
        this.builderClass = KubernetesResourceUtil.inferBuilderType(type);
        this.operationConstructor = null;
    }

    @Override
    public V edit(T item) {
        if (this.builderClass == null) {
            throw new KubernetesClientException(String.format("Cannot edit %s with visitors, no builder was found", this.type.getName()));
        }
        try {
            return (V)((VisitableBuilder)this.builderClass.getDeclaredConstructor(item.getClass()).newInstance(item));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public <L extends KubernetesResourceList<T>> HasMetadataOperation<T, L, Resource<T>> operation(Client client, Class<L> listType) {
        if (this.operationConstructor != null) {
            if (listType != null && !listType.isAssignableFrom(this.defaultListClass)) {
                throw new IllegalArgumentException(String.format("Handler type %s with list %s not compatible with %s", this.type, this.defaultListClass.getName(), listType.getName()));
            }
            return this.operationConstructor.apply(client);
        }
        return new HasMetadataOperationsImpl(client, this.context, this.type, (Class)Utils.getNonNullOrElse(listType, this.defaultListClass));
    }

    @Override
    public boolean hasOperation() {
        return this.operationConstructor != null;
    }
}

